/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.wmi.WmiTypeAdapter;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
@XmlRootElement(name="attrib")
@ValidateUsing(value="wmi-datacollection.xsd")
public class Attrib
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    protected String m_name;
    @XmlAttribute(name="alias", required=true)
    protected String m_alias;
    @XmlAttribute(name="wmiObject", required=true)
    protected String m_wmiObject;
    @XmlJavaTypeAdapter(value=WmiTypeAdapter.class)
    @XmlAttribute(name="type", required=true)
    protected AttributeType m_type;
    @XmlAttribute(name="maxval")
    protected String m_maxval;
    @XmlAttribute(name="minval")
    protected String m_minval;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = ConfigUtils.assertNotEmpty(alias, "alias");
    }

    public String getWmiObject() {
        return this.m_wmiObject;
    }

    public void setWmiObject(String wmiObject) {
        this.m_wmiObject = ConfigUtils.assertNotEmpty(wmiObject, "wmiObject");
    }

    public AttributeType getType() {
        return this.m_type;
    }

    public void setType(AttributeType value) {
        this.m_type = ConfigUtils.assertNotNull(value, "type");
    }

    public Optional<String> getMaxval() {
        return Optional.ofNullable(this.m_maxval);
    }

    public void setMaxval(String maxval) {
        this.m_maxval = ConfigUtils.normalizeString(maxval);
    }

    public Optional<String> getMinval() {
        return Optional.ofNullable(this.m_minval);
    }

    public void setMinval(String minval) {
        this.m_minval = ConfigUtils.normalizeString(minval);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Attrib)) {
            return false;
        }
        Attrib that = (Attrib)obj;
        return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_alias, that.m_alias) && Objects.equals(this.m_wmiObject, that.m_wmiObject) && Objects.equals(this.m_type, that.m_type) && Objects.equals(this.m_maxval, that.m_maxval) && Objects.equals(this.m_minval, that.m_minval);
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_alias, this.m_wmiObject, this.m_type, this.m_maxval, this.m_minval);
    }
}

