/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.statsd.PackageReportStatus;
import org.opennms.netmgt.config.statsd.Parameter;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="packageReport")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="statistics-daemon-configuration.xsd")
public class PackageReport
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final List<String> STATUS_OPTIONS = Arrays.asList("on", "off");
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="description", required=true)
    private String m_description;
    @XmlAttribute(name="schedule", required=true)
    private String m_schedule;
    @XmlAttribute(name="retainInterval", required=true)
    private String m_retainInterval;
    @XmlAttribute(name="status", required=true)
    private PackageReportStatus m_status;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = ConfigUtils.assertNotEmpty(description, "description");
    }

    public String getSchedule() {
        return this.m_schedule;
    }

    public void setSchedule(String schedule) {
        this.m_schedule = ConfigUtils.assertNotEmpty(schedule, "schedule");
    }

    public String getRetainInterval() {
        return this.m_retainInterval;
    }

    public void setRetainInterval(String retainInterval) {
        this.m_retainInterval = ConfigUtils.assertNotEmpty(retainInterval, "retainInterval");
    }

    public PackageReportStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(PackageReportStatus status) {
        this.m_status = ConfigUtils.assertOnlyContains(status, STATUS_OPTIONS, "status");
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (parameters == this.m_parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(String key, String value) {
        this.m_parameters.add(new Parameter(key, value));
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_name, this.m_description, this.m_schedule, this.m_retainInterval, this.m_status, this.m_parameters});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PackageReport) {
            PackageReport that = (PackageReport)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_description, that.m_description) && Objects.equals(this.m_schedule, that.m_schedule) && Objects.equals(this.m_retainInterval, that.m_retainInterval) && Objects.equals((Object)this.m_status, (Object)that.m_status) && Objects.equals(this.m_parameters, that.m_parameters);
        }
        return false;
    }
}

