/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.provisiond;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.opennms.netmgt.config.utils.ConfigUtils;

public class ProvisiondConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_REQUISITION_DIR = "${install.dir}/etc/imports";
    private static final String DEFAULT_FOREIGN_SOURCE_DIR = "${install.dir}/etc/foreign-sources";
    @JsonProperty(value="importThreads")
    private Long importThreads;
    @JsonProperty(value="scanThreads")
    private Long scanThreads;
    @JsonProperty(value="rescanThreads")
    private Long rescanThreads;
    @JsonProperty(value="writeThreads")
    private Long writeThreads;
    private String requistionDir;
    private String foreignSourceDir;
    @JsonProperty(value="requisition-def")
    private List<RequisitionDef> requisitionDefs = new ArrayList<RequisitionDef>();

    public Long getImportThreads() {
        return this.importThreads != null ? this.importThreads : 8L;
    }

    public void setImportThreads(Long importThreads) {
        this.importThreads = importThreads;
    }

    public Long getScanThreads() {
        return this.scanThreads != null ? this.scanThreads : 10L;
    }

    public void setScanThreads(Long scanThreads) {
        this.scanThreads = scanThreads;
    }

    public Long getRescanThreads() {
        return this.rescanThreads != null ? this.rescanThreads : 10L;
    }

    public void setRescanThreads(Long rescanThreads) {
        this.rescanThreads = rescanThreads;
    }

    public Long getWriteThreads() {
        return this.writeThreads != null ? this.writeThreads : 8L;
    }

    public void setWriteThreads(Long writeThreads) {
        this.writeThreads = writeThreads;
    }

    public String getRequistionDir() {
        return this.requistionDir != null ? this.requistionDir : DEFAULT_REQUISITION_DIR;
    }

    public void setRequistionDir(String requistionDir) {
        this.requistionDir = ConfigUtils.assertNotEmpty(requistionDir, "requisition-dir");
    }

    public String getForeignSourceDir() {
        return this.foreignSourceDir != null ? this.foreignSourceDir : DEFAULT_FOREIGN_SOURCE_DIR;
    }

    public void setForeignSourceDir(String foreignSourceDir) {
        this.foreignSourceDir = ConfigUtils.assertNotEmpty(foreignSourceDir, "foreign-source-dir");
    }

    public List<RequisitionDef> getRequisitionDefs() {
        return this.requisitionDefs;
    }

    public void setRequisitionDefs(List<RequisitionDef> requisitionDefs) {
        if (requisitionDefs == this.requisitionDefs) {
            return;
        }
        this.requisitionDefs.clear();
        if (requisitionDefs != null) {
            this.requisitionDefs.addAll(requisitionDefs);
        }
    }

    public void addRequisitionDef(RequisitionDef def) {
        this.requisitionDefs.add(def);
    }

    public boolean removeRequisitionDef(RequisitionDef def) {
        return this.requisitionDefs.remove(def);
    }

    public int hashCode() {
        return Objects.hash(this.importThreads, this.scanThreads, this.rescanThreads, this.writeThreads, this.requistionDir, this.foreignSourceDir, this.requisitionDefs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProvisiondConfiguration) {
            ProvisiondConfiguration that = (ProvisiondConfiguration)obj;
            return Objects.equals(this.importThreads, that.importThreads) && Objects.equals(this.scanThreads, that.scanThreads) && Objects.equals(this.rescanThreads, that.rescanThreads) && Objects.equals(this.writeThreads, that.writeThreads) && Objects.equals(this.requistionDir, that.requistionDir) && Objects.equals(this.foreignSourceDir, that.foreignSourceDir) && Objects.equals(this.requisitionDefs, that.requisitionDefs);
        }
        return false;
    }
}

