/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller.outages;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.poller.outages.BasicSchedule;
import org.opennms.netmgt.config.poller.outages.Interface;
import org.opennms.netmgt.config.poller.outages.Node;

@XmlRootElement(name="outage", namespace="http://xmlns.opennms.org/xsd/config/poller/outages")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="poll-outages.xsd")
public class Outage
extends BasicSchedule
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="interface")
    private List<Interface> m_interfaces = new ArrayList<Interface>();
    @XmlElement(name="node")
    private List<Node> m_nodes = new ArrayList<Node>();

    public List<Interface> getInterfaces() {
        return this.m_interfaces;
    }

    public void setInterfaces(List<Interface> interfaces) {
        if (interfaces == this.m_interfaces) {
            return;
        }
        this.m_interfaces.clear();
        if (interfaces != null) {
            this.m_interfaces.addAll(interfaces);
        }
    }

    public void addInterface(Interface iface) {
        this.m_interfaces.add(iface);
    }

    public boolean removeInterface(Interface iface) {
        return this.m_interfaces.remove(iface);
    }

    public void clearInterfaces() {
        this.m_interfaces.clear();
    }

    public List<Node> getNodes() {
        return this.m_nodes;
    }

    public void setNodes(List<Node> nodes) {
        if (nodes == this.m_nodes) {
            return;
        }
        this.m_nodes.clear();
        if (nodes != null) {
            this.m_nodes.addAll(nodes);
        }
    }

    public void addNode(Node node) {
        this.m_nodes.add(node);
    }

    public boolean removeNode(Node node) {
        return this.m_nodes.remove(node);
    }

    public void clearNodes() {
        this.m_nodes.clear();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.m_interfaces, this.m_nodes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Outage) {
            Outage that = (Outage)obj;
            return super.equals(obj) && Objects.equals(this.m_interfaces, that.m_interfaces) && Objects.equals(this.m_nodes, that.m_nodes);
        }
        return false;
    }

    public String toString() {
        return "Outage[name=" + this.getName() + ",type=" + this.getType() + ",times=" + String.valueOf(this.getTimes()) + ",interfaces=" + String.valueOf(this.m_interfaces) + ",nodes=" + String.valueOf(this.m_nodes) + "]";
    }

    public static Outage unmarshal(Reader reader) {
        return (Outage)JaxbUtils.unmarshal(Outage.class, (Reader)reader);
    }

    public void marshal(Writer writer) {
        JaxbUtils.marshal((Object)this, (Writer)writer);
    }
}

