/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.microblog;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="microblog-profile")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="microblog-configuration.xsd")
public class MicroblogProfile
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="service-url", required=true)
    private String m_serviceUrl;
    @XmlAttribute(name="authen-username")
    private String m_authenUsername;
    @XmlAttribute(name="authen-password")
    private String m_authenPassword;
    @XmlAttribute(name="oauth-consumer-key")
    private String m_oauthConsumerKey;
    @XmlAttribute(name="oauth-consumer-secret")
    private String m_oauthConsumerSecret;
    @XmlAttribute(name="oauth-access-token")
    private String m_oauthAccessToken;
    @XmlAttribute(name="oauth-access-token-secret")
    private String m_oauthAccessTokenSecret;

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public String getServiceUrl() {
        return this.m_serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.m_serviceUrl = ConfigUtils.assertNotEmpty(serviceUrl, "service-url");
    }

    public Optional<String> getAuthenUsername() {
        return Optional.ofNullable(this.m_authenUsername);
    }

    public void setAuthenUsername(String authenUsername) {
        this.m_authenUsername = authenUsername;
    }

    public Optional<String> getAuthenPassword() {
        return Optional.ofNullable(this.m_authenPassword);
    }

    public void setAuthenPassword(String authenPassword) {
        this.m_authenPassword = authenPassword;
    }

    public Optional<String> getOauthConsumerKey() {
        return Optional.ofNullable(this.m_oauthConsumerKey);
    }

    public void setOauthConsumerKey(String oauthConsumerKey) {
        this.m_oauthConsumerKey = oauthConsumerKey;
    }

    public Optional<String> getOauthConsumerSecret() {
        return Optional.ofNullable(this.m_oauthConsumerSecret);
    }

    public void setOauthConsumerSecret(String oauthConsumerSecret) {
        this.m_oauthConsumerSecret = oauthConsumerSecret;
    }

    public Optional<String> getOauthAccessToken() {
        return Optional.ofNullable(this.m_oauthAccessToken);
    }

    public void setOauthAccessToken(String oauthAccessToken) {
        this.m_oauthAccessToken = oauthAccessToken;
    }

    public Optional<String> getOauthAccessTokenSecret() {
        return Optional.ofNullable(this.m_oauthAccessTokenSecret);
    }

    public void setOauthAccessTokenSecret(String oauthAccessTokenSecret) {
        this.m_oauthAccessTokenSecret = oauthAccessTokenSecret;
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_serviceUrl, this.m_authenUsername, this.m_authenPassword, this.m_oauthConsumerKey, this.m_oauthConsumerSecret, this.m_oauthAccessToken, this.m_oauthAccessTokenSecret);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MicroblogProfile) {
            MicroblogProfile that = (MicroblogProfile)obj;
            return Objects.equals(that.m_name, this.m_name) && Objects.equals(that.m_serviceUrl, this.m_serviceUrl) && Objects.equals(that.m_authenUsername, this.m_authenUsername) && Objects.equals(that.m_authenPassword, this.m_authenPassword) && Objects.equals(that.m_oauthConsumerKey, this.m_oauthConsumerKey) && Objects.equals(that.m_oauthConsumerSecret, this.m_oauthConsumerSecret) && Objects.equals(that.m_oauthAccessToken, this.m_oauthAccessToken) && Objects.equals(that.m_oauthAccessTokenSecret, this.m_oauthAccessTokenSecret);
        }
        return false;
    }
}

