/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="user-auth")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="mail-transport-test.xsd")
public class UserAuth
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="user-name")
    private String m_userName;
    @XmlAttribute(name="password")
    private String m_password;

    public UserAuth() {
    }

    public UserAuth(String username, String password) {
        this.setUserName(username);
        this.setPassword(password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UserAuth) {
            UserAuth that = (UserAuth)obj;
            return Objects.equals(this.m_userName, that.m_userName) && Objects.equals(this.m_password, that.m_password);
        }
        return false;
    }

    public String getPassword() {
        return this.m_password == null ? "opennms" : this.m_password;
    }

    public String getUserName() {
        return this.m_userName == null ? "opennms" : this.m_userName;
    }

    public int hashCode() {
        return Objects.hash(this.m_userName, this.m_password);
    }

    public void setPassword(String password) {
        this.m_password = ConfigUtils.normalizeString(password);
    }

    public void setUserName(String userName) {
        this.m_userName = ConfigUtils.normalizeString(userName);
    }
}

