/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="exclude-url")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class ExcludeUrl
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlValue
    private String m_url;
    @XmlAttribute(name="location")
    private String m_location;
    @XmlAttribute(name="foreign-source")
    private String m_foreignSource;

    public ExcludeUrl() {
    }

    public ExcludeUrl(String url) {
        this.m_url = url;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = ConfigUtils.assertNotEmpty(url, "URL");
    }

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.m_location);
    }

    public void setLocation(String location) {
        this.m_location = ConfigUtils.normalizeString(location);
    }

    public Optional<String> getForeignSource() {
        return Optional.ofNullable(this.m_foreignSource);
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = ConfigUtils.normalizeString(foreignSource);
    }

    public int hashCode() {
        return Objects.hash(this.m_url, this.m_location, this.m_foreignSource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExcludeUrl) {
            ExcludeUrl temp = (ExcludeUrl)obj;
            return Objects.equals(temp.m_url, this.m_url) && Objects.equals(temp.m_location, this.m_location) && Objects.equals(temp.m_foreignSource, this.m_foreignSource);
        }
        return false;
    }

    public String toString() {
        return "ExcludeUrl [value=" + this.m_url + ", location=" + this.m_location + ", foreignSource=" + this.m_foreignSource + "]";
    }
}

