/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.ssl.HostnameVerifier;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.SSLWrapperFactory;
import org.apache.commons.ssl.TrustChain;

public class SSLClient
extends SSLSocketFactory {
    private final SSL ssl = new SSL();

    public void addTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.addTrustMaterial(trustChain);
    }

    public void setTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setTrustMaterial(trustChain);
    }

    public void setKeyMaterial(KeyMaterial keyMaterial) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setKeyMaterial(keyMaterial);
    }

    public void setIsSecure(boolean b) {
        this.ssl.setIsSecure(b);
    }

    public void setDnsOverride(Map m) {
        this.ssl.setDnsOverride(m);
    }

    public void setCheckCRL(boolean b) {
        this.ssl.setCheckCRL(b);
    }

    public void setCheckExpiry(boolean b) {
        this.ssl.setCheckExpiry(b);
    }

    public void setCheckHostname(boolean b) {
        this.ssl.setCheckHostname(b);
    }

    public void setConnectTimeout(int i) {
        this.ssl.setConnectTimeout(i);
    }

    public void setDefaultProtocol(String s) {
        this.ssl.setDefaultProtocol(s);
    }

    public void setEnabledCiphers(String[] ciphers) {
        this.ssl.setEnabledCiphers(ciphers);
    }

    public void setEnabledProtocols(String[] protocols) {
        this.ssl.setEnabledProtocols(protocols);
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.ssl.setHostnameVerifier(verifier);
    }

    public void setSoTimeout(int soTimeout) {
        this.ssl.setSoTimeout(soTimeout);
    }

    public void setSSLWrapperFactory(SSLWrapperFactory wf) {
        this.ssl.setSSLWrapperFactory(wf);
    }

    public void setNeedClientAuth(boolean b) {
        this.ssl.setNeedClientAuth(b);
    }

    public void setWantClientAuth(boolean b) {
        this.ssl.setWantClientAuth(b);
    }

    public void setUseClientMode(boolean b) {
        this.ssl.setUseClientMode(b);
    }

    public boolean isSecure() {
        return this.ssl.isSecure();
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        return this.ssl.getAssociatedCertificateChain();
    }

    public boolean getCheckCRL() {
        return this.ssl.getCheckCRL();
    }

    public boolean getCheckExpiry() {
        return this.ssl.getCheckExpiry();
    }

    public boolean getCheckHostname() {
        return this.ssl.getCheckHostname();
    }

    public int getConnectTimeout() {
        return this.ssl.getConnectTimeout();
    }

    public String getDefaultProtocol() {
        return this.ssl.getDefaultProtocol();
    }

    public String[] getEnabledCiphers() {
        return this.ssl.getEnabledCiphers();
    }

    public String[] getEnabledProtocols() {
        return this.ssl.getEnabledProtocols();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.ssl.getHostnameVerifier();
    }

    public int getSoTimeout() {
        return this.ssl.getSoTimeout();
    }

    public SSLWrapperFactory getSSLWrapperFactory() {
        return this.ssl.getSSLWrapperFactory();
    }

    public boolean getNeedClientAuth() {
        return this.ssl.getNeedClientAuth();
    }

    public boolean getWantClientAuth() {
        return this.ssl.getWantClientAuth();
    }

    public boolean getUseClientMode() {
        return this.ssl.getUseClientModeDefault() || this.ssl.getUseClientMode();
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        return this.ssl.getSSLContext();
    }

    public TrustChain getTrustChain() {
        return this.ssl.getTrustChain();
    }

    public X509Certificate[] getCurrentServerChain() {
        return this.ssl.getCurrentServerChain();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.ssl.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.ssl.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.ssl.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocket(host, port, null, 0);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host.getHostName(), port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocket(host.getHostName(), port, localHost, localPort);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocket(host, port, localHost, localPort, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, int timeout) throws IOException {
        return this.ssl.createSocket(host, port, localHost, localPort, timeout);
    }

    @Override
    public Socket createSocket(Socket s, String remoteHost, int remotePort, boolean autoClose) throws IOException {
        return this.ssl.createSocket(s, remoteHost, remotePort, autoClose);
    }
}

