/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckError;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;

public class TargetCheck
extends AbstractConstraintCheck {
    private final AnnotationApiHelper annotationApiHelper;
    private final EnumSet<ElementType> supportedTypes = EnumSet.of(ElementType.FIELD, ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE);

    public TargetCheck(AnnotationApiHelper annotationApiHelper) {
        this.annotationApiHelper = annotationApiHelper;
    }

    @Override
    public Set<ConstraintCheckError> checkAnnotationType(TypeElement element, AnnotationMirror annotation) {
        Target target = element.getAnnotation(Target.class);
        if (target == null) {
            return Collections.emptySet();
        }
        if (!this.containsAtLeastOneSupportedElementType(target)) {
            return CollectionHelper.asSet(new ConstraintCheckError(element, this.annotationApiHelper.getMirror(element.getAnnotationMirrors(), Target.class), "CONSTRAINT_TYPE_WITH_WRONG_TARGET", new Object[0]));
        }
        return Collections.emptySet();
    }

    private boolean containsAtLeastOneSupportedElementType(Target target) {
        ElementType[] elementTypes;
        for (ElementType oneElementType : elementTypes = target.value()) {
            if (!this.supportedTypes.contains((Object)oneElementType)) continue;
            return true;
        }
        return false;
    }
}

