/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckError;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;

public class RetentionPolicyCheck
extends AbstractConstraintCheck {
    private final AnnotationApiHelper annotationApiHelper;

    public RetentionPolicyCheck(AnnotationApiHelper annotationApiHelper) {
        this.annotationApiHelper = annotationApiHelper;
    }

    @Override
    public Set<ConstraintCheckError> checkAnnotationType(TypeElement element, AnnotationMirror annotation) {
        Retention retention = element.getAnnotation(Retention.class);
        if (retention == null) {
            return CollectionHelper.asSet(new ConstraintCheckError(element, null, "CONSTRAINT_TYPE_WITH_MISSING_OR_WRONG_RETENTION", new Object[0]));
        }
        if (!retention.value().equals((Object)RetentionPolicy.RUNTIME)) {
            return CollectionHelper.asSet(new ConstraintCheckError(element, this.annotationApiHelper.getMirror(element.getAnnotationMirrors(), Retention.class), "CONSTRAINT_TYPE_WITH_MISSING_OR_WRONG_RETENTION", new Object[0]));
        }
        return Collections.emptySet();
    }
}

