/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wsman;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.netmgt.config.wsman.Collection;
import org.opennms.netmgt.config.wsman.Group;
import org.opennms.netmgt.config.wsman.SystemDefinition;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"collection", "group", "systemDefinition"})
@XmlRootElement(name="wsman-datacollection-config")
public class WsmanDatacollectionConfig {
    @XmlElement(required=true)
    protected List<Collection> collection;
    @XmlElement(required=true)
    protected List<Group> group;
    @XmlElement(name="system-definition", required=true)
    protected List<SystemDefinition> systemDefinition;
    @XmlAttribute(name="rrd-repository")
    protected String rrdRepository;

    public List<Collection> getCollection() {
        if (this.collection == null) {
            this.collection = new ArrayList<Collection>();
        }
        return this.collection;
    }

    public void addCollection(Collection collection) {
        this.getCollection().add(Objects.requireNonNull(collection));
    }

    public List<Group> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<Group>();
        }
        return this.group;
    }

    public void addGroup(Group group) {
        this.getGroup().add(Objects.requireNonNull(group));
    }

    public List<SystemDefinition> getSystemDefinition() {
        if (this.systemDefinition == null) {
            this.systemDefinition = new ArrayList<SystemDefinition>();
        }
        return this.systemDefinition;
    }

    public void addSystemDefinition(SystemDefinition sysDef) {
        this.getSystemDefinition().add(Objects.requireNonNull(sysDef));
    }

    public String getRrdRepository() {
        return this.rrdRepository;
    }

    public void setRrdRepository(String value) {
        this.rrdRepository = value;
    }

    public WsmanDatacollectionConfig merge(WsmanDatacollectionConfig other) {
        if (other == null) {
            return this;
        }
        if (this.rrdRepository == null && other.rrdRepository != null) {
            this.rrdRepository = other.rrdRepository;
        }
        this.getCollection().addAll(other.getCollection());
        this.getGroup().addAll(other.getGroup());
        this.getSystemDefinition().addAll(other.getSystemDefinition());
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.collection, this.group, this.systemDefinition, this.rrdRepository);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WsmanDatacollectionConfig other = (WsmanDatacollectionConfig)obj;
        return Objects.equals(this.collection, other.collection) && Objects.equals(this.group, other.group) && Objects.equals(this.systemDefinition, other.systemDefinition) && Objects.equals(this.rrdRepository, other.rrdRepository);
    }
}

