/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.jmx;

import java.util.concurrent.ThreadPoolExecutor;
import org.opennms.netmgt.daemon.AbstractSpringContextJmxServiceDaemon;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.snmpinterfacepoller.SnmpPoller;
import org.opennms.netmgt.snmpinterfacepoller.jmx.SnmpPollerdMBean;

public class SnmpPollerd
extends AbstractSpringContextJmxServiceDaemon<SnmpPoller>
implements SnmpPollerdMBean {
    protected String getLoggingPrefix() {
        return "snmp-poller";
    }

    protected String getSpringContext() {
        return "snmpinterfacepollerdContext";
    }

    @Override
    public long getActiveThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getActiveCount();
        }
        return 0L;
    }

    @Override
    public long getTasksTotal() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getTaskCount();
        }
        return 0L;
    }

    @Override
    public long getTasksCompleted() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCompletedTaskCount();
        }
        return 0L;
    }

    @Override
    public double getTaskCompletionRatio() {
        if (this.getThreadPoolStatsStatus()) {
            if (this.getExecutor().getTaskCount() > 0L) {
                return (double)this.getExecutor().getCompletedTaskCount() / (double)this.getExecutor().getTaskCount();
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public long getNumPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getPoolSize();
        }
        return 0L;
    }

    @Override
    public long getPeakPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getLargestPoolSize();
        }
        return 0L;
    }

    @Override
    public long getCorePoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCorePoolSize();
        }
        return 0L;
    }

    @Override
    public long getMaxPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getMaximumPoolSize();
        }
        return 0L;
    }

    @Override
    public long getTaskQueuePendingCount() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().size();
        }
        return 0L;
    }

    @Override
    public long getTaskQueueRemainingCapacity() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().remainingCapacity();
        }
        return 0L;
    }

    private ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)((LegacyScheduler)((SnmpPoller)this.getDaemon()).getScheduler()).getRunner();
    }

    private boolean getThreadPoolStatsStatus() {
        return ((SnmpPoller)this.getDaemon()).getScheduler() instanceof LegacyScheduler;
    }
}

