/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.scriptd.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BroadcastEventProcessor
implements AutoCloseable,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private final Executor m_executor;

    BroadcastEventProcessor(Executor executor) {
        this.m_executor = executor;
        ScriptdConfigFactory aFactory = ScriptdConfigFactory.getInstance();
        if (aFactory.getEventScripts().isEmpty() && aFactory.getStopScripts().isEmpty() && aFactory.getStartScripts().isEmpty() && aFactory.getReloadScripts().isEmpty()) {
            LOG.debug("No scriptd scripts are configured; not subscribing to events");
            return;
        }
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this);
    }

    @Override
    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(IEvent event) {
        if (event == null) {
            return;
        }
        this.m_executor.addTask(event);
        LOG.debug("Added event '{}' to scriptd execution queue.", (Object)event.getUei());
    }

    public String getName() {
        return "Scriptd:BroadcastEventProcessor";
    }
}

