/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

public class RTCNodeSvcTime {
    private final long m_svcLostTime;
    private long m_svcRegainedTime;

    public RTCNodeSvcTime(long lostTime) {
        this(lostTime, -1L);
    }

    public RTCNodeSvcTime(long lostTime, long regainedTime) {
        this.m_svcLostTime = lostTime;
        this.setRegainedTime(regainedTime);
    }

    public void setRegainedTime(long t) {
        if (t <= 0L) {
            this.m_svcRegainedTime = -1L;
        } else {
            if (t < this.m_svcLostTime) {
                throw new IllegalArgumentException("Cannot set outage end time to value less than outage start time: " + this.m_svcRegainedTime + " < " + this.m_svcLostTime);
            }
            this.m_svcRegainedTime = t;
        }
    }

    public long getLostTime() {
        return this.m_svcLostTime;
    }

    public long getRegainedTime() {
        return this.m_svcRegainedTime;
    }

    public boolean hasExpired(long startOfRollingWindow) {
        if (this.m_svcRegainedTime < 0L) {
            return false;
        }
        return this.m_svcRegainedTime < startOfRollingWindow;
    }

    public long getDownTime(long curTime, long rollingWindow) {
        if (curTime < this.m_svcLostTime) {
            return 0L;
        }
        long startTime = curTime - rollingWindow;
        if (this.m_svcRegainedTime < 0L || this.m_svcRegainedTime >= curTime) {
            if (this.m_svcLostTime < startTime) {
                return rollingWindow;
            }
            return curTime - this.m_svcLostTime;
        }
        if (this.m_svcLostTime < startTime) {
            return this.m_svcRegainedTime - startTime;
        }
        return this.m_svcRegainedTime - this.m_svcLostTime;
    }
}

