/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.util.Timer;
import java.util.TimerTask;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.rtc.DataSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class RTCManager
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(RTCManager.class);
    private Timer m_timer;
    @Autowired
    private DataSender m_dataSender;
    @Autowired
    private RTCConfigFactory m_configFactory;

    private Logger log() {
        return LOG;
    }

    public RTCManager() {
        super("rtc");
        Logging.putPrefix((String)"rtc");
    }

    protected synchronized void onInit() {
        this.m_timer = new Timer();
        if (this.log().isDebugEnabled()) {
            this.log().debug("RTC ready to receive events");
        }
    }

    protected synchronized void onStart() {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Starting data sender ");
        }
        this.m_dataSender.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Updater threads and datasender started");
        }
        this.m_timer.schedule((TimerTask)new RTCTimerTask(), 0L, 120000L);
        if (this.log().isDebugEnabled()) {
            this.log().debug("userTimer scheduled");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("RTC ready to receive events");
        }
    }

    protected synchronized void onStop() {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Beginning shutdown process");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("Shutting down the data sender");
            }
            this.m_dataSender.stop();
            if (this.log().isDebugEnabled()) {
                this.log().debug("DataSender shutdown");
            }
            this.m_timer.cancel();
            if (this.log().isDebugEnabled()) {
                this.log().debug("Timer Cancelled");
            }
        }
        catch (Throwable e) {
            this.log().error(e.getLocalizedMessage(), e);
        }
    }

    private class RTCTimerTask
    extends TimerTask {
        private RTCTimerTask() {
        }

        @Override
        public void run() {
            if (RTCManager.this.isRunning()) {
                RTCManager.this.m_dataSender.notifyToSend();
            }
        }
    }
}

