/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provisiond.jmx;

import java.util.concurrent.ThreadPoolExecutor;
import org.opennms.netmgt.daemon.AbstractSpringContextJmxServiceDaemon;
import org.opennms.netmgt.provision.service.Provisioner;
import org.opennms.netmgt.provisiond.jmx.ProvisiondMBean;

public class Provisiond
extends AbstractSpringContextJmxServiceDaemon<Provisioner>
implements ProvisiondMBean {
    static final String LOG4J_CATEGORY = "provisiond";

    protected String getLoggingPrefix() {
        return LOG4J_CATEGORY;
    }

    protected String getSpringContext() {
        return "provisiondContext";
    }

    @Override
    public long getScheduledActiveThreads() {
        return this.getExecutor(ExecutorType.Rescan).getActiveCount();
    }

    @Override
    public long getScheduledNumPoolThreads() {
        return this.getExecutor(ExecutorType.Rescan).getPoolSize();
    }

    @Override
    public long getScheduledMaxPoolThreads() {
        return this.getExecutor(ExecutorType.Rescan).getMaximumPoolSize();
    }

    @Override
    public long getScheduledCorePoolThreads() {
        return this.getExecutor(ExecutorType.Rescan).getCorePoolSize();
    }

    @Override
    public long getScheduledTasksTotal() {
        return this.getExecutor(ExecutorType.Rescan).getTaskCount();
    }

    @Override
    public long getScheduledTasksCompleted() {
        return this.getExecutor(ExecutorType.Rescan).getCompletedTaskCount();
    }

    @Override
    public double getScheduledTaskCompletionRatio() {
        if (this.getExecutor(ExecutorType.Rescan).getTaskCount() > 0L) {
            return (double)this.getExecutor(ExecutorType.Rescan).getCompletedTaskCount() / (double)this.getExecutor(ExecutorType.Rescan).getTaskCount();
        }
        return 0.0;
    }

    @Override
    public long getScheduledTaskQueuePendingCount() {
        return this.getExecutor(ExecutorType.Rescan).getQueue().size();
    }

    @Override
    public long getScheduledTaskQueueRemainingCapacity() {
        return this.getExecutor(ExecutorType.Rescan).getQueue().remainingCapacity();
    }

    @Override
    public long getScanActiveThreads() {
        return this.getExecutor(ExecutorType.Scan).getActiveCount();
    }

    @Override
    public long getScanNumPoolThreads() {
        return this.getExecutor(ExecutorType.Scan).getPoolSize();
    }

    @Override
    public long getScanMaxPoolThreads() {
        return this.getExecutor(ExecutorType.Scan).getMaximumPoolSize();
    }

    @Override
    public long getScanCorePoolThreads() {
        return this.getExecutor(ExecutorType.Scan).getCorePoolSize();
    }

    @Override
    public long getScanTasksTotal() {
        return this.getExecutor(ExecutorType.Scan).getTaskCount();
    }

    @Override
    public long getScanTasksCompleted() {
        return this.getExecutor(ExecutorType.Scan).getCompletedTaskCount();
    }

    @Override
    public double getScanTaskCompletionRatio() {
        if (this.getExecutor(ExecutorType.Scan).getTaskCount() > 0L) {
            return (double)this.getExecutor(ExecutorType.Scan).getCompletedTaskCount() / (double)this.getExecutor(ExecutorType.Scan).getTaskCount();
        }
        return 0.0;
    }

    @Override
    public long getScanTaskQueuePendingCount() {
        return this.getExecutor(ExecutorType.Scan).getQueue().size();
    }

    @Override
    public long getScanTaskQueueRemainingCapacity() {
        return this.getExecutor(ExecutorType.Scan).getQueue().remainingCapacity();
    }

    @Override
    public long getImportActiveThreads() {
        return this.getExecutor(ExecutorType.Import).getActiveCount();
    }

    @Override
    public long getImportNumPoolThreads() {
        return this.getExecutor(ExecutorType.Import).getPoolSize();
    }

    @Override
    public long getImportMaxPoolThreads() {
        return this.getExecutor(ExecutorType.Import).getMaximumPoolSize();
    }

    @Override
    public long getImportCorePoolThreads() {
        return this.getExecutor(ExecutorType.Import).getCorePoolSize();
    }

    @Override
    public long getImportTasksTotal() {
        return this.getExecutor(ExecutorType.Import).getTaskCount();
    }

    @Override
    public long getImportTasksCompleted() {
        return this.getExecutor(ExecutorType.Import).getCompletedTaskCount();
    }

    @Override
    public double getImportTaskCompletionRatio() {
        if (this.getExecutor(ExecutorType.Import).getTaskCount() > 0L) {
            return (double)this.getExecutor(ExecutorType.Import).getCompletedTaskCount() / (double)this.getExecutor(ExecutorType.Import).getTaskCount();
        }
        return 0.0;
    }

    @Override
    public long getImportTaskQueuePendingCount() {
        return this.getExecutor(ExecutorType.Import).getQueue().size();
    }

    @Override
    public long getImportTaskQueueRemainingCapacity() {
        return this.getExecutor(ExecutorType.Import).getQueue().remainingCapacity();
    }

    @Override
    public long getWriteActiveThreads() {
        return this.getExecutor(ExecutorType.Write).getActiveCount();
    }

    @Override
    public long getWriteNumPoolThreads() {
        return this.getExecutor(ExecutorType.Write).getPoolSize();
    }

    @Override
    public long getWriteMaxPoolThreads() {
        return this.getExecutor(ExecutorType.Write).getMaximumPoolSize();
    }

    @Override
    public long getWriteCorePoolThreads() {
        return this.getExecutor(ExecutorType.Write).getCorePoolSize();
    }

    @Override
    public long getWriteTasksTotal() {
        return this.getExecutor(ExecutorType.Write).getTaskCount();
    }

    @Override
    public long getWriteTasksCompleted() {
        return this.getExecutor(ExecutorType.Write).getCompletedTaskCount();
    }

    @Override
    public double getWriteTaskCompletionRatio() {
        if (this.getExecutor(ExecutorType.Write).getTaskCount() > 0L) {
            return (double)this.getExecutor(ExecutorType.Write).getCompletedTaskCount() / (double)this.getExecutor(ExecutorType.Write).getTaskCount();
        }
        return 0.0;
    }

    @Override
    public long getWriteTaskQueuePendingCount() {
        return this.getExecutor(ExecutorType.Write).getQueue().size();
    }

    @Override
    public long getWriteTaskQueueRemainingCapacity() {
        return this.getExecutor(ExecutorType.Write).getQueue().remainingCapacity();
    }

    private ThreadPoolExecutor getExecutor(ExecutorType type) {
        switch (type) {
            case Import: {
                return (ThreadPoolExecutor)((Provisioner)this.getDaemon()).getTaskCoordinatorExecutorService(ExecutorType.Import.name);
            }
            case Scan: {
                return (ThreadPoolExecutor)((Provisioner)this.getDaemon()).getTaskCoordinatorExecutorService(ExecutorType.Scan.name);
            }
            case Rescan: {
                return (ThreadPoolExecutor)((Provisioner)this.getDaemon()).getScheduledExecutor();
            }
            case Write: {
                return (ThreadPoolExecutor)((Provisioner)this.getDaemon()).getTaskCoordinatorExecutorService(ExecutorType.Write.name);
            }
        }
        throw new IllegalArgumentException("unable to get executor for type: " + String.valueOf((Object)type));
    }

    public static enum ExecutorType {
        Import("import"),
        Scan("scan"),
        Rescan("rescan"),
        Write("write");

        public final String name;

        private ExecutorType(String label) {
            this.name = label;
        }
    }
}

