/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.JDBCMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCQueryMonitor
extends JDBCMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(JDBCQueryMonitor.class);
    private static final int OPERATOR_MAP_EQUALS = 0;
    private static final int OPERATOR_MAP_LESS_THAN = 1;
    private static final int OPERATOR_MAP_GREATER_THAN = 2;
    private static final int OPERATOR_MAP_NOT_EQUAL = 3;
    private static final int OPERATOR_MAP_LESS_THAN_EQUAL_TO = 4;
    private static final int OPERATOR_MAP_GREATER_THAN_EQUAL_TO = 5;
    private static final Map<String, Integer> operatorMap = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public PollStatus checkDatabaseStatus(Connection con, Map<String, Object> parameters) {
        ps = PollStatus.unavailable();
        st = null;
        query = ParameterMap.getKeyedString(parameters, (String)"query", null);
        action = ParameterMap.getKeyedString(parameters, (String)"action", (String)"row_count");
        column = ParameterMap.getKeyedString(parameters, (String)"column", null);
        operator = ParameterMap.getKeyedString(parameters, (String)"operator", (String)">=");
        message = ParameterMap.getKeyedString(parameters, (String)"message", null);
        lineSeparator = ParameterMap.getKeyedString(parameters, (String)"line-separator", (String)"\n");
        columnSeparator = ParameterMap.getKeyedString(parameters, (String)"column-separator", (String)"; ");
        columnKeySeparator = ParameterMap.getKeyedString(parameters, (String)"column-key-separator", (String)": ");
        includeFirstResult = ParameterMap.getKeyedBoolean(parameters, (String)"include-first-result", (boolean)false);
        includeAllResults = ParameterMap.getKeyedBoolean(parameters, (String)"include-all-results", (boolean)false);
        includeQuery = ParameterMap.getKeyedBoolean(parameters, (String)"include-query", (boolean)false);
        JDBCQueryMonitor.LOG.debug("Query: {}", (Object)query);
        if (query == null) {
            ps = PollStatus.unavailable("Null Query, ensure query value set in poller configuration.");
            return ps;
        }
        try {
            st = con.createStatement(1005, 1007);
            rs = st.executeQuery(query);
            rs.first();
            resultsMessage = null;
            var18_20 = action;
            var19_21 = -1;
            switch (var18_20.hashCode()) {
                case 1340416618: {
                    if (!var18_20.equals("row_count")) break;
                    var19_21 = 0;
                    break;
                }
                case 749716651: {
                    if (!var18_20.equals("compare_string")) break;
                    var19_21 = 1;
                    break;
                }
                case -412022379: {
                    if (!var18_20.equals("compare_int")) break;
                    var19_21 = 2;
                    break;
                }
                case 112000516: {
                    if (!var18_20.equals("compare_bool")) break;
                    var19_21 = 3;
                }
            }
            switch (var19_21) {
                case 0: {
                    rowCount = 0;
                    if (includeAllResults || includeFirstResult) {
                        resultsMessage = this.buildResultsMessage(rs, includeAllResults, lineSeparator, columnSeparator, columnKeySeparator);
                        if (includeAllResults) {
                            rowCount = resultsMessage.rows;
                        }
                    }
                    if (!includeAllResults) {
                        rs.last();
                        rowCount = rs.getRow();
                    }
                    if (this.integerCheck(rowCount, expectedRowCount = ParameterMap.getKeyedInteger(parameters, (String)"operand", (int)1), operator)) {
                        ps = PollStatus.available();
                        ** break;
lbl56:
                        // 1 sources

                    } else {
                        ps = PollStatus.unavailable("Row Count Check Failed: " + rowCount + " " + operator + " " + expectedRowCount);
                        if (includeQuery) {
                            ps.setReason(ps.getReason() + lineSeparator + "Query: " + query);
                        }
                        if (includeAllResults || includeFirstResult) {
                            ps.setReason(ps.getReason() + resultsMessage.message);
                            ** break;
                        }
                    }
lbl63:
                    // 3 sources

                    break;
                }
                case 1: {
                    expectedString = ParameterMap.getKeyedString(parameters, (String)"operand", null);
                    retrivedString = rs.getString(column);
                    if (expectedString.equals(retrivedString)) {
                        ps = PollStatus.available();
                        ** break;
lbl70:
                        // 1 sources

                    } else {
                        mb = new StringBuilder("String Field Check Failed: Expected: ").append(expectedString).append(" Returned: ").append(retrivedString);
                        if (includeQuery) {
                            mb.append(lineSeparator).append("Query: ").append(query);
                        }
                        if (includeAllResults || includeFirstResult) {
                            mb.append(this.buildResultsMessage((ResultSet)rs, (boolean)includeAllResults, (String)lineSeparator, (String)columnSeparator, (String)columnKeySeparator).message);
                        }
                        ps = PollStatus.unavailable(mb.toString());
                        ** break;
                    }
lbl80:
                    // 1 sources

                    break;
                }
                case 2: {
                    expectedInt = ParameterMap.getKeyedInteger(parameters, (String)"operand", (int)1);
                    retrivedInt = rs.getInt(column);
                    if (this.integerCheck(retrivedInt, expectedInt, operator)) {
                        ps = PollStatus.available();
                        ** break;
lbl87:
                        // 1 sources

                    } else {
                        mb = new StringBuilder("Integer Field Check Failed: ").append(expectedInt).append(" ").append(operator).append(" ").append(retrivedInt);
                        if (includeQuery) {
                            mb.append(lineSeparator).append("Query: ").append(query);
                        }
                        if (includeAllResults || includeFirstResult) {
                            mb.append(this.buildResultsMessage((ResultSet)rs, (boolean)includeAllResults, (String)lineSeparator, (String)columnSeparator, (String)columnKeySeparator).message);
                        }
                        ps = PollStatus.unavailable(mb.toString());
                        ** break;
                    }
lbl97:
                    // 1 sources

                    break;
                }
                case 3: {
                    expectedBool = ParameterMap.getKeyedBoolean(parameters, (String)"operand", (boolean)true);
                    retrievedBool = rs.getBoolean(column);
                    if (expectedBool == retrievedBool) {
                        ps = PollStatus.available();
                        ** break;
lbl104:
                        // 1 sources

                    } else {
                        mb = new StringBuilder("Boolean Field Check Failed: ").append(expectedBool).append(" does not equal ").append(retrievedBool).append(" found in column ").append(column);
                        if (includeQuery) {
                            mb.append(lineSeparator).append("Query: ").append(query);
                        }
                        if (includeAllResults || includeFirstResult) {
                            mb.append(this.buildResultsMessage((ResultSet)rs, (boolean)includeAllResults, (String)lineSeparator, (String)columnSeparator, (String)columnKeySeparator).message);
                        }
                        ps = PollStatus.unavailable(mb.toString());
                        ** break;
                    }
lbl114:
                    // 1 sources

                    break;
                }
                default: {
                    JDBCQueryMonitor.LOG.error("Unexpected action: {}", (Object)action);
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            ps = PollStatus.unavailable("Err: " + sqle.toString());
        }
        catch (Exception exp) {
            ps = PollStatus.unavailable("Err: " + exp.toString());
        }
        finally {
            this.closeStmt(st);
        }
        if (message != null && ps.isUnavailable()) {
            ps = PollStatus.unavailable(message + " " + ps.getReason());
        }
        return ps;
    }

    private boolean integerCheck(int val, int expected, String operator) {
        switch (operatorMap.get(operator)) {
            case 0: {
                return val == expected;
            }
            case 2: {
                return val > expected;
            }
            case 5: {
                return val >= expected;
            }
            case 1: {
                return val < expected;
            }
            case 4: {
                return val <= expected;
            }
            case 3: {
                return val != expected;
            }
        }
        return false;
    }

    private ResultsMessage buildResultsMessage(ResultSet rs, boolean includeAllResults, String lineSeparator, String columnSeparator, String columnKeySeparator) throws SQLException {
        int rows = 0;
        StringBuilder resultsMessage = new StringBuilder(lineSeparator).append("Results:");
        ResultSetMetaData rsmd = rs.getMetaData();
        boolean first = true;
        while (first || rs.next()) {
            first = false;
            if (rs.getRow() > 1 && !includeAllResults) break;
            ++rows;
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                if (i == 1) {
                    resultsMessage.append(lineSeparator);
                } else {
                    resultsMessage.append(columnSeparator);
                }
                resultsMessage.append(rsmd.getColumnName(i)).append(columnKeySeparator).append(rs.getString(i));
            }
        }
        return new ResultsMessage(resultsMessage.toString(), rows);
    }

    static {
        operatorMap.put("=", 0);
        operatorMap.put("<", 1);
        operatorMap.put(">", 2);
        operatorMap.put("!=", 3);
        operatorMap.put("<=", 4);
        operatorMap.put(">=", 5);
    }

    private final class ResultsMessage {
        public final String message;
        public final int rows;

        public ResultsMessage(String message, int rows) {
            this.message = message;
            this.rows = rows;
        }
    }
}

