/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.util.Collection;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.ErrorStatus;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.SnmpResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpNodeCollector
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpNodeCollector.class);
    private SNMPCollectorEntry m_collectorEntry;
    private String m_primaryIf;
    private SnmpCollectionSet m_collectionSet;

    public SnmpNodeCollector(InetAddress address, Collection<SnmpAttributeType> objList, SnmpCollectionSet collectionSet) {
        super(SnmpAttributeType.getCollectionTrackers(objList));
        this.m_primaryIf = InetAddressUtils.str((InetAddress)address);
        this.m_collectionSet = collectionSet;
        this.m_collectorEntry = new SNMPCollectorEntry(objList, this.m_collectionSet);
    }

    public SNMPCollectorEntry getEntry() {
        return this.m_collectorEntry;
    }

    protected void reportGenErr(String msg) {
        LOG.warn("genErr collecting data for node {}: {}", (Object)this.m_primaryIf, (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("noSuchName collecting data for node {}: {}", (Object)this.m_primaryIf, (Object)msg);
    }

    protected void reportFatalErr(ErrorStatusException ex) {
        LOG.warn("Fatal error collecting data for node {}: {}", new Object[]{this.m_primaryIf, ex.getMessage(), ex});
    }

    protected void reportNonFatalErr(ErrorStatus status) {
        LOG.info("Non-fatal error ({}) collecting data for node {}: {}", new Object[]{status, this.m_primaryIf, status.retry() ? "Retrying." : "Giving up."});
    }

    protected void storeResult(SnmpResult res) {
        this.m_collectorEntry.storeResult(res);
    }

    public SnmpCollectionSet getCollectionSet() {
        return this.m_collectionSet;
    }
}

