/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.collectd.MibPropertyAttributeType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSplitPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSplitPropertyExtender.class);
    private static final String INDEX_PATTERN = "index-pattern";

    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        String indexPattern = property.getParameterValue(INDEX_PATTERN);
        if (StringUtils.isBlank((String)indexPattern)) {
            LOG.warn("Cannot execute the Index Split property extender because: missing parameter {}", (Object)INDEX_PATTERN);
            return null;
        }
        Pattern p = Pattern.compile(indexPattern);
        Matcher m = p.matcher(targetResource.getInstance());
        if (m.find()) {
            String index = m.group(1);
            AttributeGroupType groupType = targetResource.getGroupType(property.getGroupName());
            if (groupType != null) {
                MibPropertyAttributeType type = new MibPropertyAttributeType(targetResource.getResourceType(), property, groupType);
                SnmpValue value = SnmpUtils.getValueFactory().getOctetString(index.getBytes());
                return new SnmpAttribute(targetResource, type, value);
            }
        }
        return null;
    }
}

