/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class ConsumerGroupMemberMetadataValue
implements ApiMessage {
    String instanceId;
    String rackId;
    String clientId;
    String clientHost;
    List<String> subscribedTopicNames;
    String subscribedTopicRegex;
    int rebalanceTimeoutMs;
    String serverAssignor;
    List<Assignor> assignors;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("instance_id", (Type)Type.COMPACT_NULLABLE_STRING, "The (optional) instance id."), new Field("rack_id", (Type)Type.COMPACT_NULLABLE_STRING, "The (optional) rack id."), new Field("client_id", (Type)Type.COMPACT_STRING, "The client id."), new Field("client_host", (Type)Type.COMPACT_STRING, "The client host."), new Field("subscribed_topic_names", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "The list of subscribed topic names."), new Field("subscribed_topic_regex", (Type)Type.COMPACT_NULLABLE_STRING, "The subscribed topic regular expression."), new Field("rebalance_timeout_ms", (Type)Type.INT32, "The rebalance timeout"), new Field("server_assignor", (Type)Type.COMPACT_NULLABLE_STRING, "The server assignor to use; or null if not used."), new Field("assignors", (Type)new CompactArrayOf((Type)Assignor.SCHEMA_0), "The list of assignors."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ConsumerGroupMemberMetadataValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ConsumerGroupMemberMetadataValue() {
        this.instanceId = "";
        this.rackId = "";
        this.clientId = "";
        this.clientHost = "";
        this.subscribedTopicNames = new ArrayList<String>(0);
        this.subscribedTopicRegex = "";
        this.rebalanceTimeoutMs = -1;
        this.serverAssignor = "";
        this.assignors = new ArrayList<Assignor>(0);
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        int i;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.instanceId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field instanceId had invalid length " + length);
            }
            this.instanceId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rackId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            }
            this.rackId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clientId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clientId had invalid length " + length);
        }
        this.clientId = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clientHost was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clientHost had invalid length " + length);
        }
        this.clientHost = _readable.readString(length);
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field subscribedTopicNames was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            int length2 = _readable.readUnsignedVarint() - 1;
            if (length2 < 0) {
                throw new RuntimeException("non-nullable field subscribedTopicNames element was serialized as null");
            }
            if (length2 > Short.MAX_VALUE) {
                throw new RuntimeException("string field subscribedTopicNames element had invalid length " + length2);
            }
            newCollection.add(_readable.readString(length2));
        }
        this.subscribedTopicNames = newCollection;
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.subscribedTopicRegex = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field subscribedTopicRegex had invalid length " + length);
            }
            this.subscribedTopicRegex = _readable.readString(length);
        }
        this.rebalanceTimeoutMs = _readable.readInt();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.serverAssignor = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field serverAssignor had invalid length " + length);
            }
            this.serverAssignor = _readable.readString(length);
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field assignors was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((String)((Object)new Assignor(_readable, _version)));
        }
        this.assignors = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.instanceId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.instanceId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.rackId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.rackId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _stringBytes = _cache.getSerializedValue((Object)this.clientId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.clientHost);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeUnsignedVarint(this.subscribedTopicNames.size() + 1);
        _stringBytes = this.subscribedTopicNames.iterator();
        while (_stringBytes.hasNext()) {
            String subscribedTopicNamesElement = (String)_stringBytes.next();
            byte[] _stringBytes2 = _cache.getSerializedValue((Object)subscribedTopicNamesElement);
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
        }
        if (this.subscribedTopicRegex == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.subscribedTopicRegex);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.rebalanceTimeoutMs);
        if (this.serverAssignor == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.serverAssignor);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.assignors.size() + 1);
        _stringBytes = this.assignors.iterator();
        while (_stringBytes.hasNext()) {
            Assignor assignorsElement = (Assignor)_stringBytes.next();
            assignorsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.instanceId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.instanceId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'instanceId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.instanceId, _stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        }
        if (this.rackId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.rackId, _stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        }
        _stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'clientId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clientId, _stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        _stringBytes = this.clientHost.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'clientHost' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clientHost, _stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.subscribedTopicNames.size() + 1)));
        _stringBytes = this.subscribedTopicNames.iterator();
        while (_stringBytes.hasNext()) {
            String subscribedTopicNamesElement = (String)_stringBytes.next();
            byte[] _stringBytes2 = subscribedTopicNamesElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes2.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subscribedTopicNamesElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)subscribedTopicNamesElement, _stringBytes2);
            _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
        }
        if (this.subscribedTopicRegex == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.subscribedTopicRegex.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'subscribedTopicRegex' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.subscribedTopicRegex, _stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        }
        _size.addBytes(4);
        if (this.serverAssignor == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.serverAssignor.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'serverAssignor' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.serverAssignor, _stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint((int)(((byte[])_stringBytes).length + 1)));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.assignors.size() + 1)));
        for (Assignor assignorsElement : this.assignors) {
            assignorsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerGroupMemberMetadataValue)) {
            return false;
        }
        ConsumerGroupMemberMetadataValue other = (ConsumerGroupMemberMetadataValue)obj;
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
            return false;
        }
        if (this.subscribedTopicNames == null ? other.subscribedTopicNames != null : !this.subscribedTopicNames.equals(other.subscribedTopicNames)) {
            return false;
        }
        if (this.subscribedTopicRegex == null ? other.subscribedTopicRegex != null : !this.subscribedTopicRegex.equals(other.subscribedTopicRegex)) {
            return false;
        }
        if (this.rebalanceTimeoutMs != other.rebalanceTimeoutMs) {
            return false;
        }
        if (this.serverAssignor == null ? other.serverAssignor != null : !this.serverAssignor.equals(other.serverAssignor)) {
            return false;
        }
        if (this.assignors == null ? other.assignors != null : !this.assignors.equals(other.assignors)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
        hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
        hashCode = 31 * hashCode + (this.subscribedTopicNames == null ? 0 : this.subscribedTopicNames.hashCode());
        hashCode = 31 * hashCode + (this.subscribedTopicRegex == null ? 0 : this.subscribedTopicRegex.hashCode());
        hashCode = 31 * hashCode + this.rebalanceTimeoutMs;
        hashCode = 31 * hashCode + (this.serverAssignor == null ? 0 : this.serverAssignor.hashCode());
        hashCode = 31 * hashCode + (this.assignors == null ? 0 : this.assignors.hashCode());
        return hashCode;
    }

    public ConsumerGroupMemberMetadataValue duplicate() {
        ConsumerGroupMemberMetadataValue _duplicate = new ConsumerGroupMemberMetadataValue();
        _duplicate.instanceId = this.instanceId == null ? null : this.instanceId;
        _duplicate.rackId = this.rackId == null ? null : this.rackId;
        _duplicate.clientId = this.clientId;
        _duplicate.clientHost = this.clientHost;
        ArrayList<String> newSubscribedTopicNames = new ArrayList<String>(this.subscribedTopicNames.size());
        for (String _element : this.subscribedTopicNames) {
            newSubscribedTopicNames.add(_element);
        }
        _duplicate.subscribedTopicNames = newSubscribedTopicNames;
        _duplicate.subscribedTopicRegex = this.subscribedTopicRegex == null ? null : this.subscribedTopicRegex;
        _duplicate.rebalanceTimeoutMs = this.rebalanceTimeoutMs;
        _duplicate.serverAssignor = this.serverAssignor == null ? null : this.serverAssignor;
        ArrayList<Assignor> newAssignors = new ArrayList<Assignor>(this.assignors.size());
        for (Assignor _element : this.assignors) {
            newAssignors.add(_element.duplicate());
        }
        _duplicate.assignors = newAssignors;
        return _duplicate;
    }

    public String toString() {
        return "ConsumerGroupMemberMetadataValue(instanceId=" + (this.instanceId == null ? "null" : "'" + this.instanceId.toString() + "'") + ", rackId=" + (this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ", clientId=" + (this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clientHost=" + (this.clientHost == null ? "null" : "'" + this.clientHost.toString() + "'") + ", subscribedTopicNames=" + MessageUtil.deepToString(this.subscribedTopicNames.iterator()) + ", subscribedTopicRegex=" + (this.subscribedTopicRegex == null ? "null" : "'" + this.subscribedTopicRegex.toString() + "'") + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", serverAssignor=" + (this.serverAssignor == null ? "null" : "'" + this.serverAssignor.toString() + "'") + ", assignors=" + MessageUtil.deepToString(this.assignors.iterator()) + ")";
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String rackId() {
        return this.rackId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public List<String> subscribedTopicNames() {
        return this.subscribedTopicNames;
    }

    public String subscribedTopicRegex() {
        return this.subscribedTopicRegex;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public String serverAssignor() {
        return this.serverAssignor;
    }

    public List<Assignor> assignors() {
        return this.assignors;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConsumerGroupMemberMetadataValue setInstanceId(String v) {
        this.instanceId = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setRackId(String v) {
        this.rackId = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setClientId(String v) {
        this.clientId = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setClientHost(String v) {
        this.clientHost = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setSubscribedTopicNames(List<String> v) {
        this.subscribedTopicNames = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setSubscribedTopicRegex(String v) {
        this.subscribedTopicRegex = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setRebalanceTimeoutMs(int v) {
        this.rebalanceTimeoutMs = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setServerAssignor(String v) {
        this.serverAssignor = v;
        return this;
    }

    public ConsumerGroupMemberMetadataValue setAssignors(List<Assignor> v) {
        this.assignors = v;
        return this;
    }

    public static class Assignor
    implements Message {
        String name;
        short minimumVersion;
        short maximumVersion;
        byte reason;
        short version;
        byte[] metadata;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The assignor name."), new Field("minimum_version", (Type)Type.INT16, "The minimum version supported by the assignor."), new Field("maximum_version", (Type)Type.INT16, "The maximum version supported by the assignor."), new Field("reason", (Type)Type.INT8, "The reason reported by the assignor."), new Field("version", (Type)Type.INT16, "The version used to serialize the metadata."), new Field("metadata", (Type)Type.COMPACT_BYTES, "The metadata."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Assignor(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Assignor() {
            this.name = "";
            this.minimumVersion = 0;
            this.maximumVersion = 0;
            this.reason = 0;
            this.version = 0;
            this.metadata = Bytes.EMPTY;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Assignor");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minimumVersion = _readable.readShort();
            this.maximumVersion = _readable.readShort();
            this.reason = _readable.readByte();
            this.version = _readable.readShort();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field metadata was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.metadata = newBytes;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minimumVersion);
            _writable.writeShort(this.maximumVersion);
            _writable.writeByte(this.reason);
            _writable.writeShort(this.version);
            _writable.writeUnsignedVarint(this.metadata.length + 1);
            _writable.writeByteArray(this.metadata);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Assignor");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(2);
            _size.addBytes(this.metadata.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.metadata.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Assignor)) {
                return false;
            }
            Assignor other = (Assignor)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minimumVersion != other.minimumVersion) {
                return false;
            }
            if (this.maximumVersion != other.maximumVersion) {
                return false;
            }
            if (this.reason != other.reason) {
                return false;
            }
            if (this.version != other.version) {
                return false;
            }
            if (!Arrays.equals(this.metadata, other.metadata)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.minimumVersion;
            hashCode = 31 * hashCode + this.maximumVersion;
            hashCode = 31 * hashCode + this.reason;
            hashCode = 31 * hashCode + this.version;
            hashCode = 31 * hashCode + Arrays.hashCode(this.metadata);
            return hashCode;
        }

        public Assignor duplicate() {
            Assignor _duplicate = new Assignor();
            _duplicate.name = this.name;
            _duplicate.minimumVersion = this.minimumVersion;
            _duplicate.maximumVersion = this.maximumVersion;
            _duplicate.reason = this.reason;
            _duplicate.version = this.version;
            _duplicate.metadata = MessageUtil.duplicate((byte[])this.metadata);
            return _duplicate;
        }

        public String toString() {
            return "Assignor(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minimumVersion=" + this.minimumVersion + ", maximumVersion=" + this.maximumVersion + ", reason=" + this.reason + ", version=" + this.version + ", metadata=" + Arrays.toString(this.metadata) + ")";
        }

        public String name() {
            return this.name;
        }

        public short minimumVersion() {
            return this.minimumVersion;
        }

        public short maximumVersion() {
            return this.maximumVersion;
        }

        public byte reason() {
            return this.reason;
        }

        public short version() {
            return this.version;
        }

        public byte[] metadata() {
            return this.metadata;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Assignor setName(String v) {
            this.name = v;
            return this;
        }

        public Assignor setMinimumVersion(short v) {
            this.minimumVersion = v;
            return this;
        }

        public Assignor setMaximumVersion(short v) {
            this.maximumVersion = v;
            return this;
        }

        public Assignor setReason(byte v) {
            this.reason = v;
            return this;
        }

        public Assignor setVersion(short v) {
            this.version = v;
            return this;
        }

        public Assignor setMetadata(byte[] v) {
            this.metadata = v;
            return this;
        }
    }
}

