/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.persistence.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.EdgeEntity;
import org.opennms.netmgt.graph.FocusEntity;
import org.opennms.netmgt.graph.GraphContainerEntity;
import org.opennms.netmgt.graph.GraphEntity;
import org.opennms.netmgt.graph.PropertyEntity;
import org.opennms.netmgt.graph.VertexEntity;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.persistence.converter.ConverterService;
import org.slf4j.LoggerFactory;

public class GenericToEntityMapper {
    private ConverterService converterService = new ConverterService();

    public GraphContainerEntity toEntity(GenericGraphContainer genericGraphContainer) {
        GraphContainerEntity graphContainerEntity = new GraphContainerEntity();
        graphContainerEntity.setNamespace(genericGraphContainer.getId());
        graphContainerEntity.setProperties(this.convertToPropertyEntities(genericGraphContainer.getProperties()));
        List graphEntities = genericGraphContainer.getGraphs().stream().map(genericGraph -> this.toEntity((GenericGraph)genericGraph)).collect(Collectors.toList());
        graphContainerEntity.setGraphs(graphEntities);
        return graphContainerEntity;
    }

    public GraphEntity toEntity(GenericGraph genericGraph) {
        GraphEntity graphEntity = new GraphEntity();
        graphEntity.setNamespace(genericGraph.getNamespace());
        graphEntity.setProperties(this.convertToPropertyEntities(genericGraph.getProperties()));
        List vertexEntities = genericGraph.getVertices().stream().map(genericVertex -> this.toEntity((GenericVertex)genericVertex)).collect(Collectors.toList());
        graphEntity.addRelations(vertexEntities);
        List edgeEntities = genericGraph.getEdges().stream().map(genericEdge -> this.toEntity((GenericEdge)genericEdge, graphEntity)).collect(Collectors.toList());
        graphEntity.addRelations(edgeEntities);
        Focus focus = genericGraph.getDefaultFocus();
        graphEntity.setDefaultFocus(this.toEntity(focus));
        return graphEntity;
    }

    public List<PropertyEntity> convertToPropertyEntities(Map<String, Object> properties) {
        Objects.requireNonNull(properties);
        ArrayList<PropertyEntity> propertyEntities = new ArrayList<PropertyEntity>();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            Object value = property.getValue();
            if (value == null) continue;
            String propertyName = property.getKey();
            Class<?> propertyType = value.getClass();
            try {
                String stringRepresentation = this.converterService.toStringRepresentation(propertyType, value);
                PropertyEntity propertyEntity = new PropertyEntity();
                propertyEntity.setType(propertyType);
                propertyEntity.setName(propertyName);
                propertyEntity.setValue(stringRepresentation);
                propertyEntities.add(propertyEntity);
            }
            catch (IllegalStateException ex) {
                LoggerFactory.getLogger(this.getClass()).warn("Property '{}' of type '{}' cannot be converted. Skipping property '{}'.", new Object[]{propertyName, propertyType, propertyName});
            }
        }
        return propertyEntities;
    }

    public EdgeEntity toEntity(GenericEdge genericEdge, GraphEntity graphEntity) {
        EdgeEntity edgeEntity = new EdgeEntity();
        List<PropertyEntity> edgeProperties = this.convertToPropertyEntities(genericEdge.getProperties());
        edgeEntity.setProperties(edgeProperties);
        edgeEntity.setSource(genericEdge.getSource().getNamespace(), genericEdge.getSource().getId());
        edgeEntity.setTarget(genericEdge.getTarget().getNamespace(), genericEdge.getTarget().getId());
        edgeEntity.setNamespace(genericEdge.getNamespace());
        return edgeEntity;
    }

    public VertexEntity toEntity(GenericVertex genericVertex) {
        VertexEntity vertexEntity = new VertexEntity();
        List<PropertyEntity> vertexProperties = this.convertToPropertyEntities(genericVertex.getProperties());
        vertexEntity.setNamespace(genericVertex.getNamespace());
        vertexEntity.setProperties(vertexProperties);
        return vertexEntity;
    }

    public FocusEntity toEntity(Focus focus) {
        if (focus != null) {
            FocusEntity focusEntity = new FocusEntity();
            focusEntity.setType(focus.getId());
            if (focus.getId().toLowerCase().equalsIgnoreCase("SELECTION")) {
                focusEntity.setSelection(focus.getVertexIds());
            }
            return focusEntity;
        }
        return null;
    }
}

