/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.enrichment;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentGraphBuilder;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentProcessor;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentService;
import org.opennms.netmgt.graph.api.generic.GenericGraph;

public class DefaultEnrichmentService
implements EnrichmentService {
    private final List<EnrichmentProcessor> enrichmentProcessors = new CopyOnWriteArrayList<EnrichmentProcessor>();

    public GenericGraph enrich(GenericGraph graph) {
        if (graph != null) {
            List actualProcessors = this.enrichmentProcessors.stream().filter(p -> p.canEnrich(graph)).collect(Collectors.toList());
            EnrichmentGraphBuilder enrichmentGraphBuilder = new EnrichmentGraphBuilder(graph);
            for (EnrichmentProcessor processor : actualProcessors) {
                processor.enrich(enrichmentGraphBuilder);
            }
            GenericGraph enrichedGraph = enrichmentGraphBuilder.build();
            return enrichedGraph;
        }
        return null;
    }

    public void onBind(EnrichmentProcessor enrichmentProcessor, Map<String, String> props) {
        this.enrichmentProcessors.add(enrichmentProcessor);
    }

    public void onUnbind(EnrichmentProcessor enrichmentProcessor, Map<String, String> props) {
        this.enrichmentProcessors.remove(enrichmentProcessor);
    }
}

