/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.DetectFutureNettyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectorHandlerNettyImpl<Request, Response>
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorHandlerNettyImpl.class);
    private AsyncClientConversation<Request, Response> m_conversation;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOG.debug("channelActive()");
        if (!this.getConversation().hasBanner() && this.getConversation().getRequest() != null) {
            Request request = this.getConversation().getRequest();
            ctx.channel().write(request);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.debug("channelInactive()");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.debug("Caught a Throwable in {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)cause);
        ctx.channel().close();
        ctx.fireChannelRead((Object)cause);
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) {
        try {
            AsyncClientConversation<Request, Object> conversation = this.getConversation();
            LOG.debug("Client Receiving: {}", (Object)message.toString().trim());
            LOG.debug("Conversation: {}", conversation);
            if (conversation.hasExchanges() && conversation.validate(message)) {
                Request request = conversation.getRequest();
                if (request != null) {
                    LOG.debug("Writing request: {}", request);
                    ctx.channel().write(request);
                } else if (request == null && conversation.isComplete()) {
                    LOG.debug("Closing channel: {}", conversation);
                    ctx.channel().close();
                } else {
                    LOG.debug("Closing channel, detection failed: {}", conversation);
                    ctx.channel().close();
                    ctx.fireExceptionCaught((Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
                }
            } else {
                LOG.debug("Invalid response: {}", (Object)message.toString().trim());
                ctx.channel().close();
                ctx.fireExceptionCaught((Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
            }
        }
        catch (Throwable e) {
            LOG.debug("Exception caught!", e);
            ctx.channel().close();
            ctx.fireExceptionCaught(e);
        }
    }

    public void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    public AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

