/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.sink;

import javax.annotation.PostConstruct;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.opennms.features.events.sink.module.EventSinkModule;
import org.opennms.netmgt.config.api.EventdConfig;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.springframework.beans.factory.annotation.Autowired;

public class EventSinkConsumer
implements MessageConsumer<Event, Log> {
    @Autowired
    private EventdConfig m_config;
    @Autowired
    private MessageConsumerManager messageConsumerManager;
    @Autowired
    private EventForwarder eventForwarder;

    @PostConstruct
    public void init() throws Exception {
        this.messageConsumerManager.registerConsumer((MessageConsumer)this);
    }

    public SinkModule<Event, Log> getModule() {
        return new EventSinkModule(this.m_config);
    }

    public void handleMessage(Log eventLog) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"eventd");){
            this.eventForwarder.sendNowSync(eventLog);
        }
    }

    public void setconfig(EventdConfig m_config) {
        this.m_config = m_config;
    }

    public void setMessageConsumerManager(MessageConsumerManager messageConsumerManager) {
        this.messageConsumerManager = messageConsumerManager;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }
}

