/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.component.controlbus.ControlBusEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class ControlBusComponent
extends UriEndpointComponent {
    private ExecutorService executorService;

    public ControlBusComponent() {
        super(ControlBusEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ControlBusEndpoint answer = new ControlBusEndpoint(uri, this);
        if (remaining != null && remaining.startsWith("language:")) {
            String lan = remaining.substring(9);
            answer.setLanguage(this.getCamelContext().resolveLanguage(lan));
        }
        this.setProperties(answer, parameters);
        return answer;
    }

    synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.getCamelContext().getExecutorServiceManager().newDefaultThreadPool(this, "ControlBus");
        }
        return this.executorService;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
            this.executorService = null;
        }
        super.doStop();
    }
}

