/*
 * Decompiled with CFR 0.152.
 */
package geo.google.mapping;

import geo.google.mapping.Functor;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionChain<ReturnType> {
    private Functor _head = null;
    private FunctionChain _tail = null;

    public FunctionChain(List<Functor> functions) {
        if (CollectionUtils.isNotEmpty(functions)) {
            this._head = functions.get(0);
            this._tail = new FunctionChain<ReturnType>(functions.subList(1, functions.size()));
        }
    }

    public FunctionChain(Functor[] functions) {
        this(functions, 0);
    }

    private FunctionChain(Functor[] functions, int startIndex) {
        if (startIndex < functions.length) {
            this._head = functions[startIndex];
        }
        if (startIndex < functions.length - 1) {
            this._tail = new FunctionChain<ReturnType>(functions, startIndex + 1);
        }
    }

    public FunctionChain(Functor head, FunctionChain tail) {
        this._head = head;
        this._tail = tail;
    }

    public Functor getHead() {
        return this._head;
    }

    public void setHead(Functor head) {
        this._head = head;
    }

    public FunctionChain getTail() {
        return this._tail;
    }

    public void setTail(FunctionChain tail) {
        this._tail = tail;
    }

    public ReturnType execute(Object arg) throws Exception {
        Object o = arg;
        if (this._head != null) {
            o = this._head.execute(arg);
        }
        if (this._tail != null) {
            o = this._tail.execute(o);
        }
        return (ReturnType)o;
    }

    public static FunctionChain getChain(Functor func) {
        return new FunctionChain(func, null);
    }
}

