/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset.cmd;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.topology.plugins.topo.asset.AssetGraphMLProvider;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfig;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfigBuilder;

@Command(scope="opennms", name="asset-topo-create", description="Creates Asset Topology. Uses default config if options are not supplied.")
@Service
public class CreateAssetTopologyCommand
implements Action {
    @Reference
    public AssetGraphMLProvider assetGraphMLProvider;
    @Option(name="-i", aliases={"--providerId"}, description="Unique providerId of asset topology", required=false, multiValued=false)
    String providerId;
    @Option(name="-h", aliases={"--assetLayers"}, description="Comma seperated list defining hierarchy of asset layers", required=false, multiValued=false)
    String hierarchy;
    @Option(name="-f", aliases={"--filter"}, description="Optional node filter", required=false, multiValued=false)
    String filter;
    @Option(name="-l", aliases={"--label"}, description="Asset Topology label which shows in topology menu (if --providerId is specified it is used instead of the default label when --label is not set)", required=false, multiValued=false)
    String label;
    @Option(name="-b", aliases={"--breadcrumbStrategy"}, description="Bread Crumb Strategy", required=false, multiValued=false)
    String breadcrumbStrategy;
    @Option(name="-p", aliases={"--preferredLayout"}, description="Preferred Layout", required=false, multiValued=false)
    String preferredLayout;

    public Object execute() {
        GeneratorConfig generatorConfig = new GeneratorConfigBuilder().withProviderId(this.providerId).withHierarchy(this.hierarchy).withLabel(this.label).withBreadcrumbStrategy(this.breadcrumbStrategy).withPreferredLayout(this.preferredLayout).withFilters(this.filter).build();
        System.out.println("Creating Asset Topology from configuration:");
        System.out.print(JaxbUtils.marshal((Object)generatorConfig));
        this.assetGraphMLProvider.createAssetTopology(generatorConfig);
        System.out.println("Asset Topology created");
        return null;
    }
}

