/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLEdge;
import org.opennms.features.graphml.model.GraphMLGraph;
import org.opennms.features.graphml.model.GraphMLNode;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfig;
import org.opennms.features.topology.plugins.topo.asset.NodeProvider;
import org.opennms.features.topology.plugins.topo.asset.filter.Filter;
import org.opennms.features.topology.plugins.topo.asset.filter.FilterParser;
import org.opennms.features.topology.plugins.topo.asset.layers.IdGenerator;
import org.opennms.features.topology.plugins.topo.asset.layers.ItemProvider;
import org.opennms.features.topology.plugins.topo.asset.layers.Layer;
import org.opennms.features.topology.plugins.topo.asset.layers.LayerBuilder;
import org.opennms.features.topology.plugins.topo.asset.layers.LayerDefinition;
import org.opennms.features.topology.plugins.topo.asset.layers.LayerDefinitionRepository;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetGraphGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AssetGraphGenerator.class);
    private final NodeProvider nodeProvider;

    public AssetGraphGenerator(NodeProvider nodeProvider) {
        this.nodeProvider = Objects.requireNonNull(nodeProvider);
    }

    public GraphML generateGraphs(GeneratorConfig config) {
        LayerDefinitionRepository layerDefinitionRepository = new LayerDefinitionRepository();
        List<LayerDefinition> layerDefinitions = layerDefinitionRepository.getDefinitions(config.getLayerHierarchies());
        List<OnmsNode> nodes = this.nodeProvider.getNodes(layerDefinitions);
        List<Layer> layers = layerDefinitions.stream().map(LayerDefinition::getLayer).collect(Collectors.toList());
        layers.add(new LayerBuilder().withId("nodes").withNamespace("nodes").withLabel("Nodes").withDescription("The nodes in the hierarchy of the topology").withItemProvider(node -> node).withIdGenerator(IdGenerator.SIMPLE).withSemanticZoomLevel(0).withVertexStatusProvider(true).build());
        layers.forEach(layer -> {
            List nodeWithNullValues = nodes.stream().filter(n -> layer.getItemProvider().getItem((OnmsNode)n) == null).collect(Collectors.toList());
            if (!nodeWithNullValues.isEmpty()) {
                LOG.debug("Found nodes with null value for layer (id: {}, label: {}). Removing nodes {}", new Object[]{layer.getId(), layer.getLabel(), nodeWithNullValues.stream().map(n -> String.format("(id: %s, label: %s)", n.getId(), n.getLabel())).collect(Collectors.toList())});
                nodes.removeAll(nodeWithNullValues);
            }
        });
        Map<String, Filter> filterMap = new FilterParser().parse(config.getFilters());
        List<LayerDefinition> layersToFilter = layerDefinitionRepository.getDefinitions(filterMap.keySet());
        AssetGraphGenerator.applyFilters(nodes, filterMap, layerDefinitionRepository);
        GraphML graphML = new GraphML();
        graphML.setProperty("label", (Object)config.getLabel());
        graphML.setProperty("breadcrumb-strategy", (Object)config.getBreadcrumbStrategy());
        int index = 0;
        for (Layer layer2 : layers) {
            GraphMLGraph layerGraph = new GraphMLGraph();
            layerGraph.setId(config.getProviderId() + ":" + layer2.getId());
            layerGraph.setProperty("namespace", (Object)(config.getProviderId() + ":" + layer2.getNamespace()));
            layerGraph.setProperty("preferred-layout", (Object)config.getPreferredLayout());
            layerGraph.setProperty("label", (Object)layer2.getLabel());
            layerGraph.setProperty("description", (Object)layer2.getDescription());
            layerGraph.setProperty("focus-strategy", (Object)layer2.getFocusStrategy().name());
            layerGraph.setProperty("semantic-zoom-level", (Object)layer2.getSemanticZoomLevel());
            layerGraph.setProperty("vertex-status-provider", (Object)layer2.hasVertexStatusProvider());
            for (OnmsNode eachNode : nodes) {
                Object eachItem = layer2.getItemProvider().getItem(eachNode);
                if (eachItem == null) continue;
                List<Layer> processedLayers = layers.subList(0, index);
                String id = layer2.getIdGenerator().generateId(processedLayers, eachNode, layer2.getNodeDecorator().getId(eachItem));
                if (layerGraph.getNodeById(id) != null) continue;
                GraphMLNode node2 = new GraphMLNode();
                node2.setId(id);
                layer2.getNodeDecorator().decorate(node2, eachItem);
                layerGraph.addNode(node2);
            }
            graphML.addGraph(layerGraph);
            ++index;
        }
        if (graphML.getGraphs().size() > 1) {
            nodes.forEach(n -> {
                List<GraphMLNode> path = AssetGraphGenerator.getPath(n, graphML.getGraphs(), layers);
                if (path.size() != graphML.getGraphs().size()) {
                    throw new IllegalStateException("");
                }
                for (int i = 0; i < path.size() - 1; ++i) {
                    GraphMLNode sourceNode = path.get(i);
                    GraphMLNode targetNode = path.get(i + 1);
                    GraphMLGraph sourceGraph = (GraphMLGraph)graphML.getGraphs().get(i);
                    String edgeId = String.format("%s_%s", sourceNode.getId(), targetNode.getId());
                    if (sourceGraph.getEdgeById(edgeId) != null) continue;
                    GraphMLEdge edge = new GraphMLEdge();
                    edge.setId(edgeId);
                    edge.setSource(sourceNode);
                    edge.setTarget(targetNode);
                    sourceGraph.addEdge(edge);
                }
            });
        }
        return graphML;
    }

    public static void applyFilters(List<OnmsNode> nodes, Map<String, Filter> filterMap, LayerDefinitionRepository layerDefinitionRepository) {
        List<LayerDefinition> layersToFilter = layerDefinitionRepository.getDefinitions(filterMap.keySet());
        layersToFilter.stream().filter(layerToFilter -> filterMap.get(layerToFilter.getKey()) != null).forEach(layerToFilter -> {
            List filteredNodes = nodes.stream().filter(n -> {
                ItemProvider itemProvider = layerToFilter.getLayer().getItemProvider();
                Filter filter = (Filter)filterMap.get(layerToFilter.getKey());
                return filter.apply(itemProvider.getItem((OnmsNode)n));
            }).collect(Collectors.toList());
            if (!filteredNodes.isEmpty()) {
                Layer layer = layerToFilter.getLayer();
                LOG.debug("Found nodes to remove due to filter settings. Removing nodes {}", filteredNodes.stream().map(n -> String.format("(id: %s, label: %s)", n.getId(), n.getLabel())).collect(Collectors.toList()));
                nodes.removeAll(filteredNodes);
            }
        });
    }

    private static List<GraphMLNode> getPath(OnmsNode node, List<GraphMLGraph> graphs, List<Layer> layers) {
        if (graphs.size() != layers.size()) {
            throw new IllegalArgumentException("Cannot calculate path. There are more layers than graphs, but the count must be identical");
        }
        ArrayList<GraphMLNode> path = new ArrayList<GraphMLNode>();
        for (int i = 0; i < graphs.size(); ++i) {
            GraphMLGraph graph = graphs.get(i);
            Layer layer = layers.get(i);
            Object item = layer.getItemProvider().getItem(node);
            String itemId = layer.getNodeDecorator().getId(item);
            String nodeId = layer.getIdGenerator().generateId(layers.subList(0, i), node, itemId);
            GraphMLNode GraphMlNode = graph.getNodeById(nodeId);
            if (GraphMlNode == null) {
                throw new IllegalStateException(String.format("Could not find a node with id {} in graph with id {}.", nodeId, graph.getId()));
            }
            path.add(GraphMlNode);
        }
        return path;
    }
}

