/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.ticketing.inmemory;

import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.features.ticketing.inmemory.TicketMapper;

public class InMemoryTicketerPlugin
implements Plugin {
    private final TicketMapper ticketMapper;
    private final AtomicInteger ticketIdGenerator = new AtomicInteger(0);

    public InMemoryTicketerPlugin(TicketMapper ticketMapper) {
        this.ticketMapper = ticketMapper;
    }

    public Ticket get(String ticketId) throws PluginException {
        return this.ticketMapper.getTicket(ticketId);
    }

    public void saveOrUpdate(Ticket ticket) throws PluginException {
        if (ticket.getId() == null) {
            Integer ticketId = this.ticketIdGenerator.incrementAndGet();
            ticket.setId(ticketId.toString());
        }
        this.ticketMapper.updateTicket(ticket);
    }
}

