/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.camel;

import java.util.Objects;
import java.util.Properties;
import org.opennms.core.utils.SystemInfoUtils;

public class JmsQueueNameFactory {
    private static final String NAME_FORMAT_WITH_LOCATION = "%s.%s.%s.%s";
    private static final String NAME_FORMAT_WITHOUT_LOCATION = "%s.%s.%s";
    private final String m_component;
    private final String m_endpoint;
    private final String m_location;

    public JmsQueueNameFactory(String component, String endpoint, String location) {
        this.m_component = Objects.requireNonNull(component);
        this.m_endpoint = Objects.requireNonNull(endpoint);
        this.m_location = location;
    }

    public JmsQueueNameFactory(String component, String endpoint) {
        this(component, endpoint, null);
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getComponent() {
        return this.m_component;
    }

    public String getName() {
        if (this.m_location == null) {
            return this.getNameWithoutLocation();
        }
        return this.getNameWithLocation(this.m_location);
    }

    public String getNameWithoutLocation() {
        return String.format(NAME_FORMAT_WITHOUT_LOCATION, SystemInfoUtils.getInstanceId(), this.m_component, this.m_endpoint);
    }

    public String getNameWithLocation(String location) {
        return String.format(NAME_FORMAT_WITH_LOCATION, SystemInfoUtils.getInstanceId(), location, this.m_component, this.m_endpoint);
    }

    public Properties getProperties() {
        Properties retval = new Properties();
        retval.setProperty("queueName", this.getName());
        retval.setProperty("queueNameWithoutLocation", this.getNameWithoutLocation());
        return retval;
    }
}

