/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.util.Objects;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;

public class ChainedHealthCheck
implements HealthCheck {
    private final String description;
    private final HealthCheck[] healthChecks;

    public ChainedHealthCheck(String description, HealthCheck ... healthChecks) {
        this.description = Objects.requireNonNull(description);
        this.healthChecks = healthChecks;
    }

    public String getDescription() {
        return this.description;
    }

    public Response perform(Context context) throws Exception {
        for (HealthCheck hc : this.healthChecks) {
            Response response = hc.perform(context);
            if (Status.Success.equals((Object)response.getStatus())) continue;
            return response;
        }
        return ImmutableResponse.newInstance((Status)Status.Success);
    }
}

