/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.sample.SamplePoller;
import org.opennms.integration.api.v1.collectors.CollectionRequest;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.ServiceCollector;
import org.opennms.integration.api.v1.collectors.immutables.ImmutableNumericAttribute;
import org.opennms.integration.api.v1.collectors.immutables.ImmutableStringAttribute;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.IpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.NumericAttribute;
import org.opennms.integration.api.v1.collectors.resource.Resource;
import org.opennms.integration.api.v1.collectors.resource.StringAttribute;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableCollectionSet;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableCollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableIpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableNodeResource;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(SamplePoller.class);
    private static final String INSTANCE_NAME = "opennms";
    private static final String LOCATION_KEY = "location";
    public static final String MAGIC_NUMBER_PARM = "magicNumber";
    private final RuntimeInfo runtimeInfo;

    public SampleCollector(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
    }

    public void initialize() {
    }

    public CompletableFuture<CollectionSet> collect(CollectionRequest agent, Map<String, Object> parameters) {
        CompletableFuture<CollectionSet> future = new CompletableFuture<CollectionSet>();
        double magicNumber = SampleCollector.getKeyAsDouble(MAGIC_NUMBER_PARM, parameters, Double.NaN);
        future.complete(this.buildCollectionSet(agent.getNodeId(), magicNumber));
        LOG.info("Sample Collector collection Succeeded");
        return future;
    }

    public static boolean validateCollectionSet(CollectionSet collectionSet, int nodeId, double magicNumber, String location) {
        CollectionSetResource resource = (CollectionSetResource)collectionSet.getCollectionSetResources().get(0);
        if (!Objects.equals(Resource.Type.INTERFACE, ((IpInterfaceResource)resource.getResource()).getResourceType())) {
            return false;
        }
        IpInterfaceResource ipInterfaceResource = (IpInterfaceResource)resource.getResource();
        if (!Objects.equals(INSTANCE_NAME, ipInterfaceResource.getInstance())) {
            return false;
        }
        NodeResource nodeResource = ipInterfaceResource.getNodeResource();
        if (nodeId != nodeResource.getNodeId()) {
            return false;
        }
        if (Math.abs(magicNumber - ((NumericAttribute)resource.getNumericAttributes().get(0)).getValue()) > 1.0E-5) {
            return false;
        }
        return resource.getStringAttributes().stream().anyMatch(s -> LOCATION_KEY.equals(s.getName()) && location.equals(s.getValue()));
    }

    private CollectionSet buildCollectionSet(int nodeId, double magicNumber) {
        ImmutableNodeResource nodeResource = ImmutableNodeResource.newBuilder().setNodeId(Integer.valueOf(nodeId)).build();
        ImmutableIpInterfaceResource ipInterfaceResource = ImmutableIpInterfaceResource.newInstance((NodeResource)nodeResource, (String)INSTANCE_NAME);
        ImmutableNumericAttribute numeric = ImmutableNumericAttribute.newBuilder().setGroup("group").setName("snmp").setValue(Double.valueOf(magicNumber)).setType(NumericAttribute.Type.GAUGE).build();
        ImmutableStringAttribute string = ImmutableStringAttribute.newBuilder().setName(LOCATION_KEY).setGroup("group").setValue(this.runtimeInfo.getSystemLocation()).build();
        CollectionSetResource collectionSetResource = ImmutableCollectionSetResource.newBuilder(IpInterfaceResource.class).setResource((Resource)ipInterfaceResource).addNumericAttribute((NumericAttribute)numeric).addStringAttribute((StringAttribute)string).build();
        return ImmutableCollectionSet.newBuilder().addCollectionSetResource(collectionSetResource).setTimestamp(System.currentTimeMillis()).build();
    }

    private static double getKeyAsDouble(String key, Map<String, Object> map, double defaultValue) {
        Object val = map.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble(val.toString());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static class CollectionRequestImpl
    implements CollectionRequest {
        private final int nodeId;
        private final InetAddress address;

        public CollectionRequestImpl(int nodeId, InetAddress address) {
            this.nodeId = nodeId;
            this.address = address;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public int getNodeId() {
            return this.nodeId;
        }
    }
}

