/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import org.opennms.integration.api.sample.RequisitionTestContextManager;
import org.opennms.integration.api.v1.config.requisition.Requisition;
import org.opennms.integration.api.v1.config.requisition.RequisitionInterface;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.RequisitionNode;
import org.opennms.integration.api.v1.config.requisition.SnmpPrimaryType;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisition;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionInterface;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionNode;
import org.opennms.integration.api.v1.requisition.RequisitionProvider;
import org.opennms.integration.api.v1.requisition.RequisitionRequest;

public class MyRequisitionProvider
implements RequisitionProvider {
    public static final String TYPE = "MyRequisitionProvider";
    private final RequisitionTestContextManager requisitionManager;

    public MyRequisitionProvider(RequisitionTestContextManager requisitionManager) {
        this.requisitionManager = Objects.requireNonNull(requisitionManager);
    }

    public String getType() {
        return TYPE;
    }

    public RequisitionRequest getRequest(Map<String, String> parameters) {
        return new MyRequisitonRequest(parameters);
    }

    public Requisition getRequisition(RequisitionRequest genericRequest) {
        MyRequisitonRequest request = (MyRequisitonRequest)genericRequest;
        this.requisitionManager.trackGetRequisitionForSession(request.getSessionId());
        InetAddress loopback = InetAddress.getLoopbackAddress();
        return ImmutableRequisition.newBuilder().setForeignSource(request.getForeignSource()).addNode((RequisitionNode)ImmutableRequisitionNode.newBuilder().setForeignId("n1").setNodeLabel("n1").addAsset("serialnumber", "42").addMetaData((RequisitionMetaData)ImmutableRequisitionMetaData.newBuilder().setContext("oai").setKey("sn").setValue("42").build()).addInterface((RequisitionInterface)ImmutableRequisitionInterface.newBuilder().setIpAddress(loopback).setSnmpPrimary(SnmpPrimaryType.NOT_ELIGIBLE).addMetaData((RequisitionMetaData)ImmutableRequisitionMetaData.newBuilder().setContext("oai").setKey("mac").setValue("00aabbccddee").build()).build()).build()).build();
    }

    public byte[] marshalRequest(RequisitionRequest request) {
        throw new UnsupportedOperationException("No Minion support.");
    }

    public RequisitionRequest unmarshalRequest(byte[] bytes) {
        throw new UnsupportedOperationException("No Minion support.");
    }

    private static class MyRequisitonRequest
    implements RequisitionRequest {
        private final Map<String, String> parameters;

        public MyRequisitonRequest(Map<String, String> parameters) {
            this.parameters = Objects.requireNonNull(parameters);
        }

        public String getForeignSource() {
            return this.parameters.getOrDefault("foreignSource", "fs");
        }

        public String getSessionId() {
            return this.parameters.get("sessionId");
        }
    }
}

