/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.opennms.integration.api.v1.dao.AlarmDao;
import org.opennms.integration.api.v1.graph.Edge;
import org.opennms.integration.api.v1.graph.NodeRef;
import org.opennms.integration.api.v1.graph.Vertex;
import org.opennms.integration.api.v1.graph.status.LegacyStatusProvider;
import org.opennms.integration.api.v1.graph.status.StatusInfo;
import org.opennms.integration.api.v1.graph.status.immutables.StatusInfoImmutable;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.Severity;

public class MyCustomStatusProvider
implements LegacyStatusProvider {
    private final AlarmDao alarmDao;

    public MyCustomStatusProvider(AlarmDao alarmDao) {
        this.alarmDao = Objects.requireNonNull(alarmDao);
    }

    public boolean canCalculate(String namespace) {
        return new ArrayList<String>(Arrays.asList("1", "2")).contains(namespace);
    }

    public StatusInfo calculateStatus(Vertex vertex) {
        Optional worstAlarm;
        Optional nodeRef = vertex.getNodeRef();
        if (nodeRef.isPresent() && (worstAlarm = this.alarmDao.getAlarmWithHighestSeverity((NodeRef)nodeRef.get())).isPresent()) {
            return StatusInfoImmutable.newBuilder((Severity)((Alarm)worstAlarm.get()).getSeverity()).build();
        }
        return StatusInfoImmutable.newBuilder((Severity)Severity.NORMAL).build();
    }

    public StatusInfo calculateStatus(Edge edge) {
        return StatusInfoImmutable.newBuilder((Severity)Severity.NORMAL).build();
    }
}

