/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opennms.protocols.sftp.SftpUrlConnection;
import org.opennms.protocols.sftp.SftpUrlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sftp3gppUrlConnection
extends SftpUrlConnection {
    private static final Logger LOG = LoggerFactory.getLogger(Sftp3gppUrlConnection.class);
    private Map<String, String> m_urlProperties;

    protected Sftp3gppUrlConnection(URL url) {
        super(url);
    }

    @Override
    protected String getPath() throws SftpUrlException {
        File f = new File(this.url.getPath(), this.get3gppFileName());
        String path = f.getAbsolutePath();
        LOG.debug("getPath: retrieving data 3GPP (NE Mode) using {}", (Object)path);
        return path;
    }

    public String get3gppFileName() throws SftpUrlException {
        Map<String, String> properties = this.getQueryMap();
        if (!properties.containsKey("step")) {
            throw new SftpUrlException("Missing parameter 'step'. 3GPP requires the Collection Step to generate the file name.");
        }
        if (!properties.containsKey("neid")) {
            throw new SftpUrlException("Missing parameter 'neId'. 3GPP requires NE ID to generate the file name.");
        }
        long reference = System.currentTimeMillis();
        String referenceStr = properties.get("referencetimestamp");
        if (referenceStr != null) {
            try {
                Date d = new Date(Long.parseLong(referenceStr));
                reference = d.getTime();
            }
            catch (Exception e) {
                throw new SftpUrlException("Invalid value for parameter 'referenceTimestamp': " + referenceStr);
            }
        }
        long step = Long.parseLong(properties.get("step")) * 1000L;
        long timestamp = reference - reference % step;
        LOG.debug("getPath: the reference timestamp used will be {}", (Object)new Date(timestamp));
        LOG.info("getPath: generating 3GPP file type A (NE Mode) using URL {}", (Object)this.url);
        SimpleDateFormat datef = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat timef = new SimpleDateFormat("HHmmZ");
        String tz = properties.get("timezone");
        if (tz == null) {
            LOG.debug("getPath: time zone not provided, using current timezone {}", (Object)TimeZone.getDefault().getID());
        } else {
            LOG.debug("getPath: using time zone {}", (Object)TimeZone.getTimeZone(tz).getID());
            datef.setTimeZone(TimeZone.getTimeZone(tz));
            timef.setTimeZone(TimeZone.getTimeZone(tz));
        }
        StringBuilder sb = new StringBuilder("A");
        sb.append(datef.format(new Date(timestamp)));
        sb.append(".");
        sb.append(timef.format(new Date(timestamp - step)));
        sb.append("-");
        sb.append(timef.format(new Date(timestamp)));
        sb.append("_");
        sb.append(properties.get("neid"));
        return sb.toString();
    }

    public long getTimeStampFromFile(String fileName) {
        Pattern p = Pattern.compile("\\w(\\d+)\\.(\\d+)-(\\d+)-(\\d+)-(\\d+)_.+");
        Matcher m = p.matcher(fileName);
        if (m.find()) {
            String value = m.group(1) + "-" + m.group(4);
            try {
                DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyyMMdd-HHmm");
                DateTime dateTime = dtf.parseDateTime(value);
                return dateTime.getMillis();
            }
            catch (Exception e) {
                LOG.warn("getTimeStampFromFile: malformed 3GPP file {}, because {}", (Object)fileName, (Object)e.getMessage());
                return 0L;
            }
        }
        return 0L;
    }

    public Map<String, String> getQueryMap() {
        if (this.m_urlProperties == null) {
            this.m_urlProperties = new HashMap<String, String>();
            if (this.url.getQuery() != null) {
                for (String pair : this.url.getQuery().split("&")) {
                    String[] data = pair.split("=");
                    this.m_urlProperties.put(data[0].toLowerCase(), data[1]);
                }
            }
        }
        return this.m_urlProperties;
    }

    public List<String> getFileList() throws SftpException, IOException {
        ArrayList<String> files = new ArrayList<String>();
        Vector entries = this.getChannel().ls(this.url.getPath());
        for (ChannelSftp.LsEntry entry : entries) {
            if (entry.getFilename().startsWith(".")) continue;
            files.add(entry.getFilename());
        }
        Collections.sort(files);
        return files;
    }

    public void deleteFile(String fileName) throws SftpException, IOException {
        String deleteFlag = this.getQueryMap().get("deletefile");
        if (deleteFlag != null && Boolean.parseBoolean(deleteFlag)) {
            String file = this.url.getPath() + File.separatorChar + fileName;
            LOG.debug("deleting file {} from {}", (Object)file, (Object)this.url.getHost());
            this.getChannel().rm(file);
        }
    }

    public InputStream getFile(String fileName) throws SftpException, IOException {
        return this.getChannel().get(this.url.getPath() + File.separatorChar + fileName);
    }
}

