/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.impl.ImmutableSipResponse;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipMessageBuilder;
import io.pkts.packet.sip.impl.SipResponseLine;
import java.util.List;
import java.util.Map;

public final class SipResponseBuilder
extends SipMessageBuilder<SipResponse>
implements SipResponse.Builder {
    private static final Buffer[] DEFAULT_RESPONSE_REASON = new Buffer[700];
    private static final Buffer UNKOWN_REASON = Buffers.wrap((String)"Unknown");
    private final int statusCode;
    private Buffer reason;

    public SipResponseBuilder(int statusCode) {
        super(10);
        this.statusCode = statusCode;
    }

    @Override
    protected final boolean isBuildingResponse() {
        return true;
    }

    @Override
    protected ToHeader generateDefaultToHeader() {
        throw new SipParseException("Not implemented yet and also not sure what a default To-header would be for a response");
    }

    @Override
    protected CSeqHeader generateDefaultCSeqHeader() {
        throw new SipParseException("Unable to generate a default CSeq-header for the response. You must specify it");
    }

    @Override
    protected SipInitialLine buildInitialLine() throws SipParseException {
        return new SipResponseLine(this.statusCode, this.reason != null ? this.reason : SipResponseBuilder.getDefaultResponseReason(this.statusCode));
    }

    @Override
    protected SipResponse internalBuild(Buffer msg, SipInitialLine initialLine, Map<String, List<SipHeader>> headers, SipHeader toHeader, SipHeader fromHeader, SipHeader cSeqHeader, SipHeader callIdHeader, SipHeader maxForwardsHeader, SipHeader viaHeader, SipHeader routeHeader, SipHeader recordRouteHeader, SipHeader contactHeader, Buffer body) {
        return new ImmutableSipResponse(msg, initialLine.toResponseLine(), headers, toHeader, fromHeader, cSeqHeader, callIdHeader, maxForwardsHeader, viaHeader, routeHeader, recordRouteHeader, contactHeader, body);
    }

    @Override
    public SipResponse.Builder withReasonPhrase(String reason) {
        if (reason != null && !reason.isEmpty()) {
            this.reason = Buffers.wrap((String)reason);
        }
        return this;
    }

    @Override
    public SipResponse.Builder withReasonPhrase(Buffer reason) {
        if (reason != null && !reason.isEmpty()) {
            this.reason = reason.slice();
        }
        return this;
    }

    private static Buffer getDefaultResponseReason(int statusCode) {
        Buffer reason = DEFAULT_RESPONSE_REASON[statusCode];
        if (reason != null) {
            return reason.slice();
        }
        return UNKOWN_REASON.slice();
    }

    static {
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[100] = Buffers.wrap((String)"Trying");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[180] = Buffers.wrap((String)"Ringing");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[181] = Buffers.wrap((String)"Call is Being Forwarded");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[182] = Buffers.wrap((String)"Queued");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[183] = Buffers.wrap((String)"Session Progress");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[199] = Buffers.wrap((String)"Early Dialog Terminated");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[200] = Buffers.wrap((String)"OK");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[202] = Buffers.wrap((String)"Accepted");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[204] = Buffers.wrap((String)"No Notification");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[300] = Buffers.wrap((String)"Multiple Choices");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[301] = Buffers.wrap((String)"Moved Permanently");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[302] = Buffers.wrap((String)"Moved Temporarily");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[305] = Buffers.wrap((String)"Use Proxy");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[380] = Buffers.wrap((String)"Alternative Service");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[400] = Buffers.wrap((String)"Bad Request");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[401] = Buffers.wrap((String)"Unauthorized");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[402] = Buffers.wrap((String)"Payment Required");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[403] = Buffers.wrap((String)"Forbidden");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[404] = Buffers.wrap((String)"Not Found");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[405] = Buffers.wrap((String)"Method Not Allowed");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[406] = Buffers.wrap((String)"Not Acceptable");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[407] = Buffers.wrap((String)"Proxy Authentication Required");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[408] = Buffers.wrap((String)"Request Timeout");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[409] = Buffers.wrap((String)"Conflict");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[410] = Buffers.wrap((String)"Gone");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[411] = Buffers.wrap((String)"Length Required");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[412] = Buffers.wrap((String)"Conditional Request Failed");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[413] = Buffers.wrap((String)"Request Entity Too Large");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[414] = Buffers.wrap((String)"Request-URI Too Long");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[415] = Buffers.wrap((String)"Unsupported Media Type");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[416] = Buffers.wrap((String)"Unsupported URI Scheme");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[417] = Buffers.wrap((String)"Unknown Resource-Priority");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[420] = Buffers.wrap((String)"Bad Extension");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[421] = Buffers.wrap((String)"Extension Required");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[422] = Buffers.wrap((String)"Session Interval Too Small");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[423] = Buffers.wrap((String)"Interval Too Brief");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[424] = Buffers.wrap((String)"Bad Location Information");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[428] = Buffers.wrap((String)"Use Identity Header");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[429] = Buffers.wrap((String)"Provide Referrer Identity");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[430] = Buffers.wrap((String)"Flow Failed");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[433] = Buffers.wrap((String)"Anonymity Disallowed");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[436] = Buffers.wrap((String)"Bad Identity-Info");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[437] = Buffers.wrap((String)"Unsupported Certificate");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[438] = Buffers.wrap((String)"Invalid Identity Header");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[439] = Buffers.wrap((String)"First Hop Lacks Outbound Support");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[470] = Buffers.wrap((String)"Consent Needed");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[480] = Buffers.wrap((String)"Temporarily Unavailable");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[481] = Buffers.wrap((String)"Call/Transaction Does Not Exist");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[482] = Buffers.wrap((String)"Loop Detected.");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[483] = Buffers.wrap((String)"Too Many Hops");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[484] = Buffers.wrap((String)"Address Incomplete");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[485] = Buffers.wrap((String)"Ambiguous");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[486] = Buffers.wrap((String)"Busy Here");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[487] = Buffers.wrap((String)"Request Terminated");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[488] = Buffers.wrap((String)"Not Acceptable Here");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[489] = Buffers.wrap((String)"Bad Event");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[491] = Buffers.wrap((String)"Request Pending");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[493] = Buffers.wrap((String)"Undecipherable");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[494] = Buffers.wrap((String)"Security Agreement Required");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[500] = Buffers.wrap((String)"Server Internal Error");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[501] = Buffers.wrap((String)"Not Implemented");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[502] = Buffers.wrap((String)"Bad Gateway");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[503] = Buffers.wrap((String)"Service Unavailable");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[504] = Buffers.wrap((String)"Server Time-out");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[505] = Buffers.wrap((String)"Version Not Supported");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[513] = Buffers.wrap((String)"Message Too Large");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[580] = Buffers.wrap((String)"Precondition Failure");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[600] = Buffers.wrap((String)"Busy Everywhere");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[603] = Buffers.wrap((String)"Decline");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[604] = Buffers.wrap((String)"Does Not Exist Anywhere");
        SipResponseBuilder.DEFAULT_RESPONSE_REASON[606] = Buffers.wrap((String)"Not Acceptable");
    }
}

