/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.impl.ImmutableSipMessage;
import io.pkts.packet.sip.impl.SipRequestLine;
import java.util.List;
import java.util.Map;

public class ImmutableSipRequest
extends ImmutableSipMessage
implements SipRequest {
    protected ImmutableSipRequest(Buffer message, SipRequestLine initialLine, Map<String, List<SipHeader>> headers, SipHeader toHeader, SipHeader fromHeader, SipHeader cSeqHeader, SipHeader callIdHeader, SipHeader maxForwardsHeader, SipHeader viaHeader, SipHeader routeHeader, SipHeader recordRouteHeader, SipHeader contactHeader, Buffer body) {
        super(message, initialLine, headers, toHeader, fromHeader, cSeqHeader, callIdHeader, maxForwardsHeader, viaHeader, routeHeader, recordRouteHeader, contactHeader, body);
    }

    @Override
    public URI getRequestUri() throws SipParseException {
        return this.getInitialLineAsObject().toRequestLine().getRequestUri();
    }

    @Override
    public Buffer getMethod() throws SipParseException {
        return this.getInitialLineAsObject().toRequestLine().getMethod();
    }

    @Override
    public SipResponse.Builder createResponse(int responseCode, Buffer content) throws SipParseException, ClassCastException {
        SipResponse.Builder builder = SipResponse.withStatusCode(responseCode);
        builder.withFromHeader(this.getFromHeader());
        builder.withToHeader(this.getToHeader());
        builder.withCSeqHeader(this.getCSeqHeader());
        builder.withCallIdHeader(this.getCallIDHeader());
        builder.withViaHeaders(this.getViaHeaders());
        return builder;
    }

    @Override
    public SipRequest.Builder copy() {
        SipRequest.Builder builder = SipRequest.withMethod(this.getMethod()).withRequestURI(this.getRequestUri());
        builder.withHeaders(this.getAllHeaders());
        builder.withBody(this.getContent());
        return builder;
    }

    @Override
    public final SipRequest clone() {
        return this;
    }
}

