/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.topology;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.DefaultStatus;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.graph.provider.topology.LegacyVertex;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.alarm.AlarmSummary;

public class LegacyStatusProvider
implements StatusProvider,
EdgeStatusProvider {
    private final String namespace;
    private final AlarmDao alarmDao;

    public LegacyStatusProvider(String namespace, AlarmDao alarmDao) {
        this.namespace = Objects.requireNonNull(namespace);
        this.alarmDao = Objects.requireNonNull(alarmDao);
    }

    public Map<? extends VertexRef, ? extends Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        List legacyVertices = vertices.stream().filter(eachVertex -> this.contributesTo(eachVertex.getNamespace()) && eachVertex instanceof LegacyVertex).map(eachVertex -> (LegacyVertex)((Object)eachVertex)).collect(Collectors.toList());
        Map nodeIdMap = legacyVertices.stream().filter(eachVertex -> eachVertex.getNodeID() != null).collect(Collectors.toMap(AbstractVertex::getNodeID, Function.identity()));
        Map<Integer, AlarmSummary> nodeIdToAlarmSummaryMap = this.getAlarmSummaries(nodeIdMap.keySet());
        HashMap resultMap = Maps.newHashMap();
        for (LegacyVertex eachVertex2 : legacyVertices) {
            AlarmSummary alarmSummary = nodeIdToAlarmSummaryMap.get(eachVertex2.getNodeID());
            DefaultStatus status = alarmSummary == null ? new DefaultStatus(OnmsSeverity.NORMAL.getLabel(), 0L) : new DefaultStatus(alarmSummary.getMaxSeverity().getLabel(), alarmSummary.getAlarmCount());
            resultMap.put(eachVertex2, status);
        }
        return resultMap;
    }

    public Map<? extends EdgeRef, ? extends Status> getStatusForEdges(BackendGraph graph, Collection<EdgeRef> edges, Criteria[] criteria) {
        HashMap edgeStatusMap = Maps.newHashMap();
        for (EdgeRef eachEdge : edges) {
            edgeStatusMap.put(eachEdge, new Status(){

                public String computeStatus() {
                    return "up";
                }

                public Map<String, String> getStatusProperties() {
                    return ImmutableMap.of((Object)"status", (Object)"up");
                }

                public Map<String, String> getStyleProperties() {
                    return Maps.newHashMap();
                }
            });
        }
        return edgeStatusMap;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    private Map<Integer, AlarmSummary> getAlarmSummaries(Set<Integer> nodeIds) {
        return this.alarmDao.getNodeAlarmSummariesIncludeAcknowledgedOnes((List)Lists.newArrayList(nodeIds)).stream().collect(Collectors.toMap(AlarmSummary::getNodeId, Function.identity()));
    }
}

