/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.ValidationException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.apache.ws.commons.schema.docpath.XmlSchemaStateMachineNode;
import org.apache.ws.commons.schema.walker.XmlSchemaAttrInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaRestriction;
import org.apache.ws.commons.schema.walker.XmlSchemaTypeInfo;
import org.xml.sax.Attributes;

final class XmlSchemaElementValidator {
    private static DatatypeFactory datatypeFactory = null;

    XmlSchemaElementValidator() {
    }

    private static DatatypeFactory getDatatypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException("Unable to create the DatatypeFactory for validating XML Schema durations.", e);
            }
        }
        return datatypeFactory;
    }

    static void validateAttributes(XmlSchemaStateMachineNode state, Attributes attrs, NamespaceContext nsContext) throws ValidationException {
        if (state == null || attrs == null || nsContext == null || !state.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) {
            throw new ValidationException("None of state, attrs, or nsContext can be null, and state must be of an SchemaStateMachineNode.Type.ELEMENT node, not " + (Object)((Object)(state == null ? null : state.getNodeType())));
        }
        List<XmlSchemaAttrInfo> attributes = state.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        QName elemQName = state.getElement().getQName();
        for (XmlSchemaAttrInfo attribute : attributes) {
            XmlSchemaAttribute xmlSchemaAttr = attribute.getAttribute();
            QName attrQName = xmlSchemaAttr.getQName();
            XmlSchemaUse use = xmlSchemaAttr.getUse();
            String value = attrs.getValue(attrQName.getNamespaceURI(), attrQName.getLocalPart());
            if (value == null) {
                value = attrs.getValue("", attrQName.getLocalPart());
            }
            if (value != null) {
                value = value.trim();
            }
            switch (use) {
                case OPTIONAL: {
                    break;
                }
                case PROHIBITED: {
                    if (value == null || value.length() <= 0) break;
                    throw new ValidationException("Attribute " + attrQName + " was declared 'prohibited' by " + elemQName + " and cannot have a value.");
                }
                case REQUIRED: {
                    if (value != null && value.length() != 0) break;
                    throw new ValidationException("Attribute " + attrQName + " was declared 'required' by " + elemQName + " and must have a value.");
                }
                default: {
                    throw new ValidationException("Attribute " + attrQName + " of element " + elemQName + " has an unrecognized usage of " + use + ".");
                }
            }
            if (value == null || value.length() == 0) continue;
            if (attribute.getType().getType().equals((Object)XmlSchemaTypeInfo.Type.COMPLEX)) {
                throw new ValidationException("Attribute " + attrQName + " of element " + elemQName + " cannot have a COMPLEX type.");
            }
            XmlSchemaElementValidator.validateType("Attribute " + attrQName + " of " + elemQName, value, attribute.getType(), nsContext);
        }
    }

    static void validateContent(XmlSchemaStateMachineNode state, String elementContent, NamespaceContext nsContext) throws ValidationException {
        if (state == null || nsContext == null || !state.getNodeType().equals((Object)XmlSchemaStateMachineNode.Type.ELEMENT)) {
            throw new ValidationException("Niether state nor nsContext can be null, and state must be of an SchemaStateMachineNode.Type.ELEMENT node, not " + (Object)((Object)(state == null ? null : state.getNodeType())));
        }
        QName elemQName = state.getElement().getQName();
        XmlSchemaTypeInfo elemType = state.getElementType();
        XmlSchemaElement element = state.getElement();
        if (elementContent != null) {
            elementContent = elementContent.trim();
        }
        switch (elemType.getType()) {
            case COMPLEX: {
                if (elemType.isMixed() || elementContent == null || elementContent.length() <= 0) break;
                throw new ValidationException(elemQName + " is a non-mixed complex type, therefore there should not be any content between the tags, like \"" + elementContent + "\".");
            }
            case ATOMIC: 
            case LIST: 
            case UNION: {
                if (elementContent == null || elementContent.length() == 0) {
                    if (state.getElement().isNillable()) {
                        return;
                    }
                    elementContent = element.getDefaultValue();
                    if (elementContent == null) {
                        elementContent = element.getFixedValue();
                    }
                    if (elementContent == null) {
                        throw new ValidationException("Element " + elemQName + " has no content, no default value, and no fixed value, but is of type " + (Object)((Object)elemType.getType()) + ".");
                    }
                }
                XmlSchemaElementValidator.validateType(elemQName.toString(), elementContent, elemType, nsContext);
                break;
            }
            default: {
                throw new IllegalStateException(elemQName + " has an unrecognized content type of " + (Object)((Object)elemType.getType()) + ".");
            }
        }
    }

    private static void validateType(String name, String value, XmlSchemaTypeInfo typeInfo, NamespaceContext nsContext) throws ValidationException {
        if (value == null || value.length() == 0) {
            throw new ValidationException(name + " cannot have a null or empty value!");
        }
        HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets = typeInfo.getFacets();
        switch (typeInfo.getType()) {
            case ATOMIC: {
                XmlSchemaElementValidator.validateAtomicType(name, value, typeInfo, nsContext);
                break;
            }
            case LIST: {
                String[] values;
                for (String item : values = value.split(" ")) {
                    XmlSchemaElementValidator.validateType(name + " item value \"" + item + "\"", item, typeInfo.getChildTypes().get(0), nsContext);
                }
                XmlSchemaElementValidator.listLengthChecks(name, values, facets);
                break;
            }
            case UNION: {
                boolean foundValidType = false;
                for (XmlSchemaTypeInfo unionType : typeInfo.getChildTypes()) {
                    try {
                        XmlSchemaElementValidator.validateType(name, value, unionType, nsContext);
                        foundValidType = true;
                        break;
                    }
                    catch (ValidationException validationException) {
                    }
                }
                if (foundValidType) break;
                StringBuilder errMsg = new StringBuilder(name);
                errMsg.append(" does not validate against any of its union of");
                errMsg.append(" types.  The value is \"").append(value);
                errMsg.append("\" and the union types are: ");
                for (int childIndex = 0; childIndex < typeInfo.getChildTypes().size() - 1; ++childIndex) {
                    errMsg.append((Object)typeInfo.getChildTypes().get(childIndex).getBaseType());
                    errMsg.append(", ");
                }
                errMsg.append((Object)typeInfo.getChildTypes().get(typeInfo.getChildTypes().size() - 1).getBaseType());
                errMsg.append('.');
                throw new ValidationException(errMsg.toString());
            }
            case COMPLEX: {
                if (typeInfo.isMixed()) break;
                throw new ValidationException(name + " has a value of \"" + value + "\" but it represents a non-mixed complex type.");
            }
            default: {
                throw new ValidationException(name + " has an unrecognized type of " + (Object)((Object)typeInfo.getType()));
            }
        }
    }

    private static void validateAtomicType(String name, String value, XmlSchemaTypeInfo typeInfo, NamespaceContext nsContext) throws ValidationException {
        if (!typeInfo.getType().equals((Object)XmlSchemaTypeInfo.Type.ATOMIC)) {
            throw new ValidationException(name + " must have a type of ATOMIC, not " + (Object)((Object)typeInfo.getType()));
        }
        if (value == null || value.length() == 0) {
            throw new ValidationException(name + " cannot have a null or empty value when validating.");
        }
        HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets = typeInfo.getFacets();
        switch (typeInfo.getBaseType()) {
            case ANYTYPE: 
            case ANYSIMPLETYPE: 
            case ANYURI: 
            case STRING: {
                XmlSchemaElementValidator.stringLengthChecks(name, DatatypeConverter.parseString((String)value), facets);
                break;
            }
            case DURATION: {
                try {
                    XmlSchemaElementValidator.getDatatypeFactory().newDuration(value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid duration.", (Throwable)iae);
                }
            }
            case DATETIME: {
                try {
                    DatatypeConverter.parseDateTime((String)value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid date-time.", (Throwable)iae);
                }
            }
            case TIME: {
                try {
                    DatatypeConverter.parseTime((String)value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid time.", (Throwable)iae);
                }
            }
            case DATE: {
                try {
                    DatatypeConverter.parseDate((String)value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid date.", (Throwable)iae);
                }
            }
            case YEARMONTH: {
                try {
                    XmlSchemaElementValidator.getDatatypeFactory().newXMLGregorianCalendar(value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid Year-Month.", (Throwable)iae);
                }
            }
            case YEAR: {
                try {
                    XmlSchemaElementValidator.getDatatypeFactory().newXMLGregorianCalendar(value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid year.", (Throwable)iae);
                }
            }
            case MONTHDAY: {
                try {
                    XmlSchemaElementValidator.getDatatypeFactory().newXMLGregorianCalendar(value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid month-day.", (Throwable)iae);
                }
            }
            case DAY: {
                try {
                    XmlSchemaElementValidator.getDatatypeFactory().newXMLGregorianCalendar(value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid day.", (Throwable)iae);
                }
            }
            case MONTH: {
                try {
                    XmlSchemaElementValidator.getDatatypeFactory().newXMLGregorianCalendar(value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid month.", (Throwable)iae);
                }
            }
            case BOOLEAN: {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) break;
                throw new ValidationException(name + " value of \"" + value + "\" is not a valid boolean; must be \"true\" or \"false\".");
            }
            case BIN_BASE64: {
                try {
                    DatatypeConverter.parseBase64Binary((String)value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not valid base-64 binary.", (Throwable)iae);
                }
            }
            case BIN_HEX: {
                try {
                    DatatypeConverter.parseHexBinary((String)value);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not valid hexadecimal binary.", (Throwable)iae);
                }
            }
            case FLOAT: {
                try {
                    XmlSchemaElementValidator.rangeChecks(name, BigDecimal.valueOf(DatatypeConverter.parseFloat((String)value)), facets);
                    break;
                }
                catch (NumberFormatException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid float.", (Throwable)iae);
                }
            }
            case DECIMAL: {
                try {
                    BigDecimal decimal = DatatypeConverter.parseDecimal((String)value);
                    XmlSchemaElementValidator.rangeChecks(name, decimal, facets);
                    XmlSchemaElementValidator.digitsFacetChecks(name, decimal, facets);
                    break;
                }
                catch (NumberFormatException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid decimal.", (Throwable)iae);
                }
            }
            case DOUBLE: {
                try {
                    XmlSchemaElementValidator.rangeChecks(name, BigDecimal.valueOf(DatatypeConverter.parseDouble((String)value)), facets);
                    break;
                }
                catch (NumberFormatException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid double.", (Throwable)iae);
                }
            }
            case QNAME: {
                try {
                    DatatypeConverter.parseQName((String)value, (NamespaceContext)nsContext);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid .", (Throwable)iae);
                }
            }
            case NOTATION: {
                try {
                    String[] qNames;
                    for (String qName : qNames = value.split(" ")) {
                        DatatypeConverter.parseQName((String)qName, (NamespaceContext)nsContext);
                    }
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException(name + " value of \"" + value + "\" is not a valid series of QNames.", (Throwable)iae);
                }
            }
            default: {
                throw new ValidationException(name + " has an unrecognized base value type of " + (Object)((Object)typeInfo.getBaseType()));
            }
        }
        XmlSchemaElementValidator.checkEnumerationFacet(name, value, facets);
    }

    private static void rangeChecks(String name, BigDecimal value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) throws ValidationException {
        if (facets == null) {
            return;
        }
        XmlSchemaElementValidator.rangeCheck(name, value, facets, XmlSchemaRestriction.Type.EXCLUSIVE_MIN);
        XmlSchemaElementValidator.rangeCheck(name, value, facets, XmlSchemaRestriction.Type.INCLUSIVE_MIN);
        XmlSchemaElementValidator.rangeCheck(name, value, facets, XmlSchemaRestriction.Type.EXCLUSIVE_MAX);
        XmlSchemaElementValidator.rangeCheck(name, value, facets, XmlSchemaRestriction.Type.INCLUSIVE_MAX);
    }

    private static void rangeCheck(String name, BigDecimal value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets, XmlSchemaRestriction.Type rangeType) throws ValidationException {
        List<XmlSchemaRestriction> rangeFacets = facets.get((Object)rangeType);
        boolean satisfied = true;
        BigDecimal compareTo = null;
        if (rangeFacets != null && !rangeFacets.isEmpty()) {
            for (XmlSchemaRestriction rangeFacet : rangeFacets) {
                compareTo = XmlSchemaElementValidator.getBigDecimalOf(rangeFacet.getValue());
                int comparison = value.compareTo(compareTo);
                switch (rangeType) {
                    case EXCLUSIVE_MIN: {
                        satisfied = comparison > 0;
                        break;
                    }
                    case INCLUSIVE_MIN: {
                        satisfied = comparison >= 0;
                        break;
                    }
                    case EXCLUSIVE_MAX: {
                        satisfied = comparison < 0;
                        break;
                    }
                    case INCLUSIVE_MAX: {
                        satisfied = comparison <= 0;
                        break;
                    }
                    default: {
                        throw new ValidationException("Cannot perform a range check of type " + (Object)((Object)rangeType));
                    }
                }
                if (satisfied) continue;
                break;
            }
        }
        if (!satisfied) {
            throw new ValidationException(name + " value \"" + value + "\" violates the " + (Object)((Object)rangeType) + " restriction of " + compareTo + ".");
        }
    }

    private static BigDecimal getBigDecimalOf(Object numericValue) {
        BigDecimal newValue = null;
        if (numericValue instanceof BigDecimal) {
            newValue = (BigDecimal)numericValue;
        } else if (numericValue instanceof Double) {
            newValue = BigDecimal.valueOf((Double)numericValue);
        } else if (numericValue instanceof Float) {
            newValue = BigDecimal.valueOf(((Float)numericValue).floatValue());
        } else if (numericValue instanceof BigInteger) {
            newValue = new BigDecimal((BigInteger)numericValue);
        } else if (numericValue instanceof Number) {
            newValue = new BigDecimal(((Number)numericValue).longValue());
        } else if (numericValue instanceof String) {
            newValue = new BigDecimal(numericValue.toString());
        } else {
            throw new IllegalArgumentException(numericValue.getClass().getName() + " is not a subclass of java.lang.Number.");
        }
        return newValue;
    }

    private static void stringLengthChecks(String name, String value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) throws ValidationException {
        if (facets == null) {
            return;
        }
        XmlSchemaElementValidator.stringLengthCheck(name, value, facets, XmlSchemaRestriction.Type.LENGTH);
        XmlSchemaElementValidator.stringLengthCheck(name, value, facets, XmlSchemaRestriction.Type.LENGTH_MIN);
        XmlSchemaElementValidator.stringLengthCheck(name, value, facets, XmlSchemaRestriction.Type.LENGTH_MAX);
    }

    private static void stringLengthCheck(String name, String value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets, XmlSchemaRestriction.Type facetType) throws ValidationException {
        List<XmlSchemaRestriction> lengthFacets = facets.get((Object)facetType);
        int lengthRestriction = -1;
        boolean satisfied = true;
        if (lengthFacets != null) {
            for (XmlSchemaRestriction lengthFacet : lengthFacets) {
                lengthRestriction = Integer.parseInt(lengthFacet.getValue().toString());
                switch (facetType) {
                    case LENGTH: {
                        satisfied = value.length() == lengthRestriction;
                        break;
                    }
                    case LENGTH_MIN: {
                        satisfied = value.length() >= lengthRestriction;
                        break;
                    }
                    case LENGTH_MAX: {
                        satisfied = value.length() <= lengthRestriction;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot perform a length restriction of type " + (Object)((Object)facetType));
                    }
                }
                if (satisfied) continue;
                break;
            }
        }
        if (!satisfied) {
            throw new ValidationException(name + " value \"" + value + "\" does not meet the " + (Object)((Object)facetType) + " restriction of " + lengthRestriction + ".");
        }
    }

    private static void listLengthChecks(String name, String[] value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) throws ValidationException {
        if (facets == null) {
            return;
        }
        XmlSchemaElementValidator.listLengthCheck(name, value, facets, XmlSchemaRestriction.Type.LENGTH);
        XmlSchemaElementValidator.listLengthCheck(name, value, facets, XmlSchemaRestriction.Type.LENGTH_MIN);
        XmlSchemaElementValidator.listLengthCheck(name, value, facets, XmlSchemaRestriction.Type.LENGTH_MAX);
    }

    private static void listLengthCheck(String name, String[] value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets, XmlSchemaRestriction.Type facetType) throws ValidationException {
        List<XmlSchemaRestriction> lengthFacets = facets.get((Object)facetType);
        int lengthRestriction = -1;
        boolean satisfied = true;
        if (lengthFacets != null) {
            for (XmlSchemaRestriction lengthFacet : lengthFacets) {
                lengthRestriction = Integer.parseInt(lengthFacet.getValue().toString());
                switch (facetType) {
                    case LENGTH: {
                        satisfied = value.length == lengthRestriction;
                        break;
                    }
                    case LENGTH_MIN: {
                        satisfied = value.length >= lengthRestriction;
                        break;
                    }
                    case LENGTH_MAX: {
                        satisfied = value.length <= lengthRestriction;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot perform a length restriction of type " + (Object)((Object)facetType));
                    }
                }
                if (satisfied) continue;
                break;
            }
        }
        if (!satisfied) {
            throw new ValidationException(name + " value of length " + value.length + " does not meet the " + (Object)((Object)facetType) + " restriction of " + lengthRestriction + ".");
        }
    }

    private static void digitsFacetChecks(String name, BigDecimal value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) throws ValidationException {
        if (facets == null) {
            return;
        }
        XmlSchemaElementValidator.digitsFacetCheck(name, value, facets, XmlSchemaRestriction.Type.DIGITS_FRACTION);
        XmlSchemaElementValidator.digitsFacetCheck(name, value, facets, XmlSchemaRestriction.Type.DIGITS_TOTAL);
    }

    private static void digitsFacetCheck(String name, BigDecimal value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets, XmlSchemaRestriction.Type facetType) throws ValidationException {
        List<XmlSchemaRestriction> digitsFacets = facets.get((Object)facetType);
        int numDigits = 0;
        boolean satisfied = true;
        if (digitsFacets != null) {
            block4: for (XmlSchemaRestriction digitsFacet : digitsFacets) {
                numDigits = Integer.parseInt(digitsFacet.getValue().toString());
                switch (facetType) {
                    case DIGITS_FRACTION: {
                        satisfied = value.scale() <= numDigits;
                        continue block4;
                    }
                    case DIGITS_TOTAL: {
                        satisfied = value.precision() <= numDigits;
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Cannot perform a digits facet check with a facet of type " + (Object)((Object)facetType));
            }
        }
        if (!satisfied) {
            StringBuilder errMsg = new StringBuilder(name);
            errMsg.append(" value \"").append(value);
            errMsg.append("\" does not meet the ").append((Object)facetType);
            errMsg.append(" check of ").append(numDigits).append(" digits.");
            throw new ValidationException(errMsg.toString());
        }
    }

    private static void checkEnumerationFacet(String name, String value, Map<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) throws ValidationException {
        if (facets == null) {
            return;
        }
        List<XmlSchemaRestriction> enumFacets = facets.get((Object)XmlSchemaRestriction.Type.ENUMERATION);
        if (enumFacets == null) {
            return;
        }
        boolean found = false;
        for (XmlSchemaRestriction enumFacet : enumFacets) {
            if (!value.equals(enumFacet.getValue().toString())) continue;
            found = true;
            break;
        }
        if (!found) {
            StringBuilder errMsg = new StringBuilder(name);
            errMsg.append(" value \"").append(value).append("\" is not a member of");
            errMsg.append(" the enumeration {\"");
            for (int enumIndex = 0; enumIndex < enumFacets.size() - 1; ++enumIndex) {
                errMsg.append(enumFacets.get(enumIndex).getValue()).append("\", \"");
            }
            errMsg.append(enumFacets.get(enumFacets.size() - 1).getValue());
            errMsg.append("\"}.");
            throw new ValidationException(errMsg.toString());
        }
    }
}

