/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.geocoder.GeocoderConfiguration;
import org.opennms.features.geocoder.GeocoderConfigurationException;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geocoder.GeocoderServiceManager;
import org.opennms.features.geocoder.GeocoderServiceManagerConfiguration;
import org.opennms.features.geocoder.service.ConfigurationWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class DefaultGeocoderServiceManager
implements GeocoderServiceManager {
    private static final String PID = "org.opennms.features.geocoder";
    private static final Function<String, String> configPidFactory = geocoderId -> "org.opennms.features.geocoder." + geocoderId;
    private BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private GeocoderServiceManagerConfiguration configuration;

    public DefaultGeocoderServiceManager(BundleContext bundleContext, ConfigurationAdmin configurationAdmin, GeocoderServiceManagerConfiguration configuration) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
        this.configurationAdmin = Objects.requireNonNull(configurationAdmin);
        this.configuration = Objects.requireNonNull(configuration);
    }

    public void resetConfiguration() throws IOException {
        for (GeocoderService service : this.getGeocoderServices()) {
            String configPid = configPidFactory.apply(service.getId());
            Configuration configuration = this.configurationAdmin.getConfiguration(configPid, null);
            new ConfigurationWrapper(configuration).delete();
        }
        new ConfigurationWrapper(this.configurationAdmin.getConfiguration(PID)).delete();
    }

    public void updateConfiguration(GeocoderServiceManagerConfiguration newConfiguration) throws IOException {
        Configuration configuration = this.configurationAdmin.getConfiguration(PID);
        new ConfigurationWrapper(configuration).update(newConfiguration.asMap());
    }

    public GeocoderServiceManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public GeocoderService getActiveGeocoderService() {
        if (this.configuration.getActiveGeocoderId() == null || "".equals(this.configuration.getActiveGeocoderId())) {
            return null;
        }
        return this.getGeocoderService(this.configuration.getActiveGeocoderId());
    }

    public List<GeocoderService> getGeocoderServices() {
        try {
            List<GeocoderService> registeredServices = this.bundleContext.getServiceReferences(GeocoderService.class, null).stream().map(reference -> (GeocoderService)this.bundleContext.getService(reference)).collect(Collectors.toList());
            return registeredServices;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Could not retrieve registered GeocoderServices.", e);
        }
    }

    public void updateGeocoderConfiguration(String geocoderId, Map<String, Object> newProperties) throws IOException, GeocoderConfigurationException {
        GeocoderService geocoderService = this.getGeocoderService(geocoderId);
        GeocoderConfiguration currentConfiguration = geocoderService.getConfiguration();
        if (!Objects.equals(currentConfiguration.asMap(), newProperties)) {
            geocoderService.validateConfiguration(newProperties);
            String configPID = configPidFactory.apply(geocoderId);
            Configuration configuration = this.configurationAdmin.getConfiguration(configPID, null);
            new ConfigurationWrapper(configuration).update(newProperties);
        }
    }

    public GeocoderService getGeocoderService(String geocoderId) {
        Objects.requireNonNull(geocoderId);
        GeocoderService geocoderService = this.getGeocoderServices().stream().filter(service -> geocoderId.equalsIgnoreCase(service.getId())).findFirst().orElseThrow(() -> new NoSuchElementException("Could not find GeocoderService with id '" + geocoderId + "'"));
        return geocoderService;
    }
}

