/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.requisition;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.poller.support.DefaultServiceMonitorRegistry;
import org.opennms.netmgt.provision.persist.RequisitionProvider;
import org.opennms.netmgt.provision.persist.RequisitionProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequisitionProviderRegistry
implements RequisitionProviderRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceMonitorRegistry.class);
    private static final String TYPE = "type";
    private final Map<String, RequisitionProvider> m_providersByType = new HashMap<String, RequisitionProvider>();

    public synchronized void onBind(RequisitionProvider provider, Map properties) {
        LOG.debug("bind called with {}: {}", (Object)provider, (Object)properties);
        if (provider != null) {
            String type = DefaultRequisitionProviderRegistry.getType(properties);
            if (type == null) {
                LOG.warn("Unable to determine the type for provider: {}, with properties: {}. The provider will not be registered.", (Object)provider, (Object)properties);
                return;
            }
            this.m_providersByType.put(type, provider);
        }
    }

    public synchronized void onUnbind(RequisitionProvider provider, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)provider, (Object)properties);
        if (provider != null) {
            String type = DefaultRequisitionProviderRegistry.getType(properties);
            if (type == null) {
                LOG.warn("Unable to determine the class name for provider: {}, with properties: {}. The provider will not be unregistered.", (Object)provider, (Object)properties);
                return;
            }
            this.m_providersByType.remove(type, provider);
        }
    }

    public RequisitionProvider getProviderByType(String type) {
        return this.m_providersByType.get(type);
    }

    public Set<String> getTypes() {
        return ImmutableSet.copyOf(this.m_providersByType.keySet());
    }

    private static String getType(Map<?, ?> properties) {
        Object type = properties.get(TYPE);
        if (type != null && type instanceof String) {
            return (String)type;
        }
        return null;
    }
}

