/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.usageanalytics.impl;

import java.util.List;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.usageanalytics.api.UsageAnalytic;
import org.opennms.features.usageanalytics.api.UsageAnalyticDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageAnalyticDaoImpl
extends AbstractDaoHibernate<UsageAnalytic, Long>
implements UsageAnalyticDao {
    private static final Logger LOG = LoggerFactory.getLogger(UsageAnalyticDaoImpl.class);

    public UsageAnalyticDaoImpl() {
        super(UsageAnalytic.class);
    }

    public long getValueByMetricName(String metricName) {
        LOG.info("Getting value of the object with metric name : " + metricName);
        UsageAnalytic ua = null;
        CriteriaBuilder cb = new CriteriaBuilder(UsageAnalytic.class);
        cb.eq("metricName", (Object)metricName);
        List uaList = this.findMatching(cb.toCriteria());
        if (uaList.isEmpty()) {
            return 0L;
        }
        ua = (UsageAnalytic)uaList.get(0);
        return ua.getCounter();
    }

    public void incrementCounterByMetricName(String metricName) {
        LOG.info("Going to get UsageAnalytic object with metric name : " + metricName);
        UsageAnalytic ua = null;
        CriteriaBuilder cb = new CriteriaBuilder(UsageAnalytic.class);
        cb.eq("metricName", (Object)metricName);
        List uaList = this.findMatching(cb.toCriteria());
        if (uaList.isEmpty()) {
            ua = new UsageAnalytic();
            ua.setMetricName(metricName);
            ua.setCounter(Long.valueOf(0L));
        } else {
            ua = (UsageAnalytic)uaList.get(0);
        }
        ua.setCounter(Long.valueOf(ua.getCounter() + 1L));
        super.saveOrUpdate((Object)ua);
    }
}

