/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.flows.classification.internal.decision.Bound;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;
import org.opennms.netmgt.flows.classification.persistence.api.Protocol;
import org.opennms.netmgt.flows.classification.persistence.api.Protocols;

public class ProtocolValue {
    private final Set<Integer> protocols;

    public static ProtocolValue of(String string) {
        Set<Integer> protocols = new StringValue(string).splitBy(",").stream().map(p -> Protocols.getProtocol((String)p.getValue())).filter(p -> p != null).map(Protocol::getDecimal).collect(Collectors.toSet());
        return new ProtocolValue(protocols);
    }

    public ProtocolValue(Set<Integer> protocols) {
        this.protocols = protocols;
    }

    public Set<Integer> getProtocols() {
        return this.protocols;
    }

    public ProtocolValue shrink(Bound<Integer> bound) {
        HashSet<Integer> s = new HashSet<Integer>(this.protocols.size());
        for (Integer i : this.protocols) {
            if (!bound.canBeRestrictedBy(i)) continue;
            s.add(i);
        }
        return s.isEmpty() ? null : (s.size() == this.protocols.size() ? this : new ProtocolValue(s));
    }
}

