/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import java.util.ArrayList;
import java.util.List;
import org.opennms.core.network.IPPortRange;
import org.opennms.netmgt.flows.classification.internal.decision.Bound;
import org.opennms.netmgt.flows.classification.internal.value.IntegerValue;
import org.opennms.netmgt.flows.classification.internal.value.RangedValue;
import org.opennms.netmgt.flows.classification.internal.value.RuleValue;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;

public class PortValue
implements RuleValue<Integer, PortValue> {
    private final List<IPPortRange> ranges;

    public static PortValue of(String input) {
        StringValue portValue = new StringValue(input);
        if (portValue.hasWildcard()) {
            throw new IllegalArgumentException("Wildcards not supported");
        }
        List<StringValue> portValues = portValue.splitBy(",");
        ArrayList<IPPortRange> ranges = new ArrayList<IPPortRange>();
        for (StringValue pv : portValues) {
            if (pv.isRanged()) {
                RangedValue rv = new RangedValue(pv);
                ranges.add(new IPPortRange(rv.getStart(), rv.getEnd()));
                continue;
            }
            IntegerValue iv = new IntegerValue(pv);
            ranges.add(new IPPortRange(iv.getValue()));
        }
        return new PortValue(ranges);
    }

    public PortValue(List<IPPortRange> ranges) {
        this.ranges = ranges;
    }

    public List<IPPortRange> getPortRanges() {
        return this.ranges;
    }

    public boolean matches(int port) {
        for (IPPortRange r : this.ranges) {
            if (!r.contains(port)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PortValue shrink(Bound<Integer> bound) {
        ArrayList<IPPortRange> l = new ArrayList<IPPortRange>(this.ranges.size());
        for (IPPortRange r : this.ranges) {
            if (!bound.overlaps(r.getBegin(), r.getEnd())) continue;
            l.add(r);
        }
        return l.isEmpty() ? null : (this.ranges.size() == l.size() ? this : new PortValue(l));
    }
}

