/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.flows.classification.IpAddr;
import org.opennms.netmgt.flows.classification.internal.decision.Bound;
import org.opennms.netmgt.flows.classification.internal.value.IpRange;
import org.opennms.netmgt.flows.classification.internal.value.RuleValue;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpValue
implements RuleValue<IpAddr, IpValue> {
    private static final Logger LOG = LoggerFactory.getLogger(IpValue.class);
    private final List<IpRange> ranges;

    public static IpValue of(String input) {
        return IpValue.of(new StringValue(input));
    }

    public static IpValue of(StringValue input) {
        Objects.requireNonNull(input);
        if (input.isNullOrEmpty()) {
            throw new IllegalArgumentException("input may not be null or empty");
        }
        List<StringValue> actualValues = input.splitBy(",");
        ArrayList<IpRange> ranges = new ArrayList<IpRange>();
        for (StringValue eachValue : actualValues) {
            if (eachValue.isRanged()) {
                List<StringValue> rangedValues = eachValue.splitBy("-");
                if (rangedValues.size() != 2) {
                    LOG.warn("Received multiple ranges {}. Will only use {}", rangedValues, rangedValues.subList(0, 2));
                }
                for (StringValue rangedValue : rangedValues) {
                    if (!rangedValue.contains("/")) continue;
                    throw new IllegalArgumentException("Ranged value may not contain a CIDR expression");
                }
                ranges.add(IpRange.of(rangedValues.get(0).getValue(), rangedValues.get(1).getValue()));
                continue;
            }
            if (eachValue.getValue().contains("/")) {
                ranges.add(IpValue.parseCIDR(eachValue.getValue()));
                continue;
            }
            ranges.add(IpRange.of(eachValue.getValue()));
        }
        return new IpValue(ranges);
    }

    public IpValue(List<IpRange> ranges) {
        this.ranges = ranges;
    }

    public boolean isInRange(IpAddr address) {
        for (IpRange r : this.ranges) {
            if (!r.contains(address)) continue;
            return true;
        }
        return false;
    }

    public List<IpRange> getIpAddressRanges() {
        return this.ranges;
    }

    public static IpRange parseCIDR(String cidr) {
        int slashIndex = cidr.indexOf(47);
        if (slashIndex == -1) {
            throw new IllegalArgumentException("Value is not a CIDR expression");
        }
        byte[] address = InetAddressUtils.toIpAddrBytes((String)cidr.substring(0, slashIndex));
        int mask = Integer.parseInt(cidr.substring(slashIndex + 1));
        byte[] lower = Arrays.copyOf(address, address.length);
        for (int i = lower.length - 1; i >= mask / 8; --i) {
            if (i * 8 >= mask) {
                lower[i] = 0;
                continue;
            }
            int n = i;
            lower[n] = (byte)(lower[n] & 255 << 8 - (mask - i * 8));
        }
        byte[] upper = Arrays.copyOf(address, address.length);
        for (int i = upper.length - 1; i >= mask / 8; --i) {
            if (i * 8 >= mask) {
                upper[i] = -1;
                continue;
            }
            int n = i;
            upper[n] = (byte)(upper[n] | 255 >> mask - i * 8);
        }
        return IpRange.of(InetAddressUtils.toIpAddrString((byte[])lower), InetAddressUtils.toIpAddrString((byte[])upper));
    }

    @Override
    public IpValue shrink(Bound<IpAddr> bound) {
        ArrayList<IpRange> l = new ArrayList<IpRange>(this.ranges.size());
        for (IpRange r : this.ranges) {
            if (!bound.overlaps(r.begin, r.end)) continue;
            l.add(r);
        }
        return l.isEmpty() ? null : (this.ranges.size() == l.size() ? this : new IpValue(l));
    }
}

