/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jdbc.response;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCResponse {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCResponse.class);
    private ResultSet m_result;
    private boolean m_isValidProcedureCall = false;
    private boolean m_isValidQuery = false;

    public void receive(Connection conn) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        LOG.debug("got database metadata");
        this.m_result = metadata.getCatalogs();
    }

    public boolean resultSetNotNull() {
        try {
            while (this.m_result.next()) {
                this.m_result.getString(1);
                LOG.debug("Metadata catalog: '{}'", (Object)this.m_result.getString(1));
            }
            this.m_result.close();
            return true;
        }
        catch (SQLException e) {
            LOG.info("Unable to get result set", (Throwable)e);
            return false;
        }
    }

    public boolean validProcedureCall() {
        return this.isValidProcedureCall();
    }

    public void setValidProcedureCall(boolean isValidProcedureCall) {
        this.m_isValidProcedureCall = isValidProcedureCall;
    }

    public boolean isValidProcedureCall() {
        return this.m_isValidProcedureCall;
    }

    public boolean isValidQuery() {
        return this.m_isValidQuery;
    }

    public void setValidQuery(boolean isValidQuery) {
        this.m_isValidQuery = isValidQuery;
    }
}

