/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GrafanaDashletQuickRangePicker
extends HorizontalLayout {
    private final int quickRangeColumns = 4;
    private final Map<String, QuickRange>[] quickRangeColumn = new TreeMap[4];
    private final List<QuickRangeListener> quickRangeListeners = new ArrayList<QuickRangeListener>();
    private final Map<QuickRange, Button> buttonMap = new HashMap<QuickRange, Button>();
    private Button selectedButton;

    public GrafanaDashletQuickRangePicker() {
        int i;
        for (i = 0; i < 4; ++i) {
            this.quickRangeColumn[i] = new TreeMap<String, QuickRange>();
        }
        this.quickRangeColumn[0].put("Last 2 days", new QuickRange("now-2d", "now"));
        this.quickRangeColumn[0].put("Last 7 days", new QuickRange("now-7d", "now"));
        this.quickRangeColumn[0].put("Last 30 days", new QuickRange("now-30d", "now"));
        this.quickRangeColumn[0].put("Last 60 days", new QuickRange("now-60d", "now"));
        this.quickRangeColumn[0].put("Last 6 months", new QuickRange("now-6M", "now"));
        this.quickRangeColumn[0].put("Last 1 year", new QuickRange("now-1y", "now"));
        this.quickRangeColumn[0].put("Last 2 years", new QuickRange("now-2y", "now"));
        this.quickRangeColumn[0].put("Last 5 years", new QuickRange("now-5y", "now"));
        this.quickRangeColumn[1].put("Yesterday", new QuickRange("now-1d/d", "now-1d/d"));
        this.quickRangeColumn[1].put("Day before yesterday", new QuickRange("now-2d/d", "now-2d/d"));
        this.quickRangeColumn[1].put("This day last week", new QuickRange("now-7d/d", "now-7d/d"));
        this.quickRangeColumn[1].put("Previous week", new QuickRange("now-1w/w", "now-1w/w"));
        this.quickRangeColumn[1].put("Previous month", new QuickRange("now-1M/M", "now-1M/M"));
        this.quickRangeColumn[1].put("Previous year", new QuickRange("now-1y/y", "now-1y/y"));
        this.quickRangeColumn[2].put("Today", new QuickRange("now/d", "now/d"));
        this.quickRangeColumn[2].put("Today so far", new QuickRange("now/d", "now"));
        this.quickRangeColumn[2].put("This week", new QuickRange("now/w", "now/w"));
        this.quickRangeColumn[2].put("This week so far", new QuickRange("now/w", "now"));
        this.quickRangeColumn[2].put("This month", new QuickRange("now/M", "now/M"));
        this.quickRangeColumn[2].put("This year", new QuickRange("now/y", "now/y"));
        this.quickRangeColumn[3].put("Last 5 minutes", new QuickRange("now-5m", "now"));
        this.quickRangeColumn[3].put("Last 15 minutes", new QuickRange("now-15m", "now"));
        this.quickRangeColumn[3].put("Last 30 minutes", new QuickRange("now-30m", "now"));
        this.quickRangeColumn[3].put("Last 1 hour", new QuickRange("now-1h", "now"));
        this.quickRangeColumn[3].put("Last 3 hours", new QuickRange("now-3h", "now"));
        this.quickRangeColumn[3].put("Last 6 hours", new QuickRange("now-6h", "now"));
        this.quickRangeColumn[3].put("Last 12 hours", new QuickRange("now-12h", "now"));
        this.quickRangeColumn[3].put("Last 24 hours", new QuickRange("now-24h", "now"));
        this.setMargin(true);
        this.setSpacing(true);
        for (i = 0; i < 4; ++i) {
            this.addComponent((Component)this.createLayout(this.quickRangeColumn[i]));
        }
    }

    private VerticalLayout createLayout(Map<String, QuickRange> quickRanges) {
        VerticalLayout verticalLayout = new VerticalLayout();
        for (Map.Entry<String, QuickRange> entry : quickRanges.entrySet()) {
            Button button = new Button(entry.getKey());
            button.addStyleName("link");
            button.addClickListener((Button.ClickListener & Serializable)e -> {
                for (QuickRangeListener quickRangeListener : this.quickRangeListeners) {
                    quickRangeListener.quickRangeSelected((QuickRange)entry.getValue());
                }
                this.selectButton(button);
            });
            verticalLayout.addComponent((Component)button);
            this.buttonMap.put(entry.getValue(), button);
        }
        return verticalLayout;
    }

    private void selectButton(Button button) {
        if (this.selectedButton != null) {
            this.selectedButton.removeStyleName("caption-bold");
        }
        this.selectedButton = button;
        if (this.selectedButton != null) {
            this.selectedButton.addStyleName("caption-bold");
        }
    }

    public void selectQuickRange(String from, String to) {
        QuickRange quickRange = new QuickRange(from, to);
        this.selectButton(this.buttonMap.get(quickRange));
    }

    public void addQuickRangeListener(QuickRangeListener quickRangeListener) {
        if (quickRangeListener != null) {
            this.quickRangeListeners.add(quickRangeListener);
        }
    }

    public void removeQuickRangeListener(QuickRangeListener quickRangeListener) {
        if (quickRangeListener != null) {
            this.quickRangeListeners.remove(quickRangeListener);
        }
    }

    public static class QuickRange {
        private final String from;
        private final String to;

        public QuickRange(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuickRange that = (QuickRange)o;
            if (this.getFrom() != null ? !this.getFrom().equals(that.getFrom()) : that.getFrom() != null) {
                return false;
            }
            return this.getTo() != null ? this.getTo().equals(that.getTo()) : that.getTo() == null;
        }

        public int hashCode() {
            int result = this.getFrom() != null ? this.getFrom().hashCode() : 0;
            result = 31 * result + (this.getTo() != null ? this.getTo().hashCode() : 0);
            return result;
        }
    }

    public static interface QuickRangeListener {
        public void quickRangeSelected(QuickRange var1);
    }
}

