/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.alarmd.Alarmd;
import org.opennms.netmgt.alarmd.StripedExt;
import org.opennms.netmgt.alarmd.api.AlarmPersisterExtension;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.UpdateField;
import org.opennms.netmgt.xml.eventconf.LogDestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionOperations;

public class AlarmPersisterImpl
implements AlarmPersister {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmPersisterImpl.class);
    public static final String RELATED_REDUCTION_KEY_PREFIX = "related-reductionKey";
    protected static final Integer NUM_STRIPE_LOCKS = SystemProperties.getInteger((String)"org.opennms.alarmd.stripe.locks", (int)(Alarmd.THREADS * 4));
    protected static boolean NEW_IF_CLEARED = Boolean.getBoolean("org.opennms.alarmd.newIfClearedAlarmExists");
    protected static boolean LEGACY_ALARM_STATE = Boolean.getBoolean("org.opennms.alarmd.legacyAlarmState");
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private EventUtil m_eventUtil;
    @Autowired
    private TransactionOperations m_transactionOperations;
    @Autowired
    private AlarmEntityNotifier m_alarmEntityNotifier;
    private Striped<Lock> lockStripes = StripedExt.fairLock(NUM_STRIPE_LOCKS);
    private final Set<AlarmPersisterExtension> extensions = Sets.newConcurrentHashSet();
    private boolean m_createNewAlarmIfClearedAlarmExists = LEGACY_ALARM_STATE ? false : NEW_IF_CLEARED;
    private boolean m_legacyAlarmState = LEGACY_ALARM_STATE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnmsAlarm persist(Event event) {
        OnmsAlarm alarm;
        Objects.requireNonNull(event, "Cannot create alarm from null event.");
        if (!AlarmPersisterImpl.checkEventSanityAndDoWeProcess(event)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("process: {}; nodeid: {}; ipaddr: {}; serviceid: {}, instanceId={}, eventId={}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService(), SystemInfoUtils.getInstanceId(), event.getDbid()});
        }
        Iterable locks = this.lockStripes.bulkGet(AlarmPersisterImpl.getLockKeys(event));
        try {
            locks.forEach(Lock::lock);
            alarm = (OnmsAlarm)this.m_transactionOperations.execute(action -> this.addOrReduceEventAsAlarm(event));
        }
        catch (Exception e) {
            LOG.warn("Exception while reducing event to alarm, instanceId={}, eventId={}", new Object[]{SystemInfoUtils.getInstanceId(), event.getDbid(), e});
            OnmsAlarm onmsAlarm = null;
            return onmsAlarm;
        }
        finally {
            locks.forEach(Lock::unlock);
        }
        return alarm;
    }

    private OnmsAlarm addOrReduceEventAsAlarm(Event event) throws IllegalStateException {
        OnmsAlarm alarm;
        OnmsEvent persistedEvent = (OnmsEvent)this.m_eventDao.get((Serializable)event.getDbid());
        if (persistedEvent == null) {
            throw new IllegalStateException("Event with id " + event.getDbid() + " was deleted before we could retrieve it and create an alarm.");
        }
        String reductionKey = event.getAlarmData().getReductionKey();
        LOG.debug("addOrReduceEventAsAlarm: looking for existing reduction key: {}", (Object)reductionKey);
        String key = reductionKey;
        String clearKey = event.getAlarmData().getClearKey();
        boolean didSwapReductionKeyWithClearKey = false;
        if (!this.m_legacyAlarmState && clearKey != null && this.isResolutionEvent(event)) {
            key = clearKey;
            didSwapReductionKeyWithClearKey = true;
        }
        if ((alarm = this.m_alarmDao.findByReductionKey(key)) == null && didSwapReductionKeyWithClearKey) {
            alarm = this.m_alarmDao.findByReductionKey(reductionKey);
        }
        if (alarm == null || this.m_createNewAlarmIfClearedAlarmExists && OnmsSeverity.CLEARED.equals((Object)alarm.getSeverity())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} not found, instantiating new alarm", (Object)reductionKey);
            }
            if (alarm != null) {
                LOG.debug("addOrReduceEventAsAlarm: \"archiving\" cleared Alarm for problem: {}; A new alarm will be instantiated to manage the problem.", (Object)reductionKey);
                alarm.archive();
                this.m_alarmDao.save((Object)alarm);
                this.m_alarmDao.flush();
                this.m_alarmEntityNotifier.didArchiveAlarm(alarm, reductionKey);
            }
            alarm = this.createNewAlarm(persistedEvent, event);
            try {
                OnmsAlarm alarmCreated = alarm;
                this.extensions.forEach(ext -> ext.afterAlarmCreated(alarmCreated, event, persistedEvent));
            }
            catch (Exception ex) {
                LOG.error("An error occurred while invoking the extension callbacks, instanceId={}, alarmId={}", new Object[]{SystemInfoUtils.getInstanceId(), alarm.getId(), ex});
            }
            this.m_alarmDao.save((Object)alarm);
            this.m_eventDao.saveOrUpdate((Object)persistedEvent);
            this.m_alarmEntityNotifier.didCreateAlarm(alarm);
        } else {
            LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} found, reducing event to existing alarm: {}, instanceId={}, alarmId={}", new Object[]{reductionKey, alarm.getId(), SystemInfoUtils.getInstanceId(), alarm.getId()});
            this.reduceEvent(persistedEvent, alarm, event);
            try {
                OnmsAlarm alarmUpdated = alarm;
                this.extensions.forEach(ext -> ext.afterAlarmUpdated(alarmUpdated, event, persistedEvent));
            }
            catch (Exception ex) {
                LOG.error("An error occurred while invoking the extension callbacks, instanceId={}, alarmId={}", new Object[]{SystemInfoUtils.getInstanceId(), alarm.getId(), ex});
            }
            this.m_alarmDao.update((Object)alarm);
            this.m_eventDao.update((Object)persistedEvent);
            if (event.getAlarmData().isAutoClean().booleanValue()) {
                this.m_eventDao.deletePreviousEventsForAlarm(alarm.getId(), persistedEvent);
            }
            this.m_alarmEntityNotifier.didUpdateAlarmWithReducedEvent(alarm);
        }
        return alarm;
    }

    private void reduceEvent(OnmsEvent persistedEvent, OnmsAlarm alarm, Event event) {
        alarm.setLastEvent(persistedEvent);
        alarm.setLastEventTime(persistedEvent.getEventTime());
        if (!this.isResolutionEvent(event)) {
            this.incrementCounter(alarm);
            if (this.isResolvedAlarm(alarm)) {
                this.resetAlarmSeverity(persistedEvent, alarm);
            }
        } else if (this.isResolvedAlarm(alarm)) {
            this.incrementCounter(alarm);
        } else {
            alarm.setSeverity(OnmsSeverity.CLEARED);
        }
        alarm.setAlarmType(event.getAlarmData().getAlarmType());
        if (!event.getAlarmData().hasUpdateFields().booleanValue()) {
            alarm.setLogMsg(persistedEvent.getEventLogMsg());
        } else {
            for (UpdateField field : event.getAlarmData().getUpdateFieldList()) {
                String fieldName = field.getFieldName();
                if (fieldName.equalsIgnoreCase("LogMsg") && !field.isUpdateOnReduction().booleanValue()) continue;
                alarm.setLogMsg(persistedEvent.getEventLogMsg());
                if (field.isUpdateOnReduction().booleanValue()) {
                    if (fieldName.toLowerCase().startsWith("distpoller")) {
                        alarm.setDistPoller(persistedEvent.getDistPoller());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("ipaddr")) {
                        alarm.setIpAddr(persistedEvent.getIpAddr());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("mouseover")) {
                        alarm.setMouseOverText(persistedEvent.getEventMouseOverText());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("operinstruct")) {
                        alarm.setOperInstruct(persistedEvent.getEventOperInstruct());
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("severity")) {
                        this.resetAlarmSeverity(persistedEvent, alarm);
                        continue;
                    }
                    if (fieldName.toLowerCase().contains("descr")) {
                        alarm.setDescription(persistedEvent.getEventDescr());
                        continue;
                    }
                    if (fieldName.toLowerCase().startsWith("acktime")) {
                        String expandedAckTime = this.m_eventUtil.expandParms(field.getValueExpression(), event);
                        if ("null".equalsIgnoreCase(expandedAckTime) && alarm.isAcknowledged()) {
                            alarm.unacknowledge("admin");
                            continue;
                        }
                        if ("".equals(expandedAckTime) || expandedAckTime.toLowerCase().startsWith("now")) {
                            alarm.setAlarmAckTime(Calendar.getInstance().getTime());
                            continue;
                        }
                        if (expandedAckTime.matches("^\\d+$")) {
                            try {
                                long ackTimeLong = Long.valueOf(expandedAckTime);
                                if (ackTimeLong < 0xFA00000000L) {
                                    alarm.setAlarmAckTime(new Date(ackTimeLong * 1000L));
                                    continue;
                                }
                                alarm.setAlarmAckTime(new Date(ackTimeLong));
                            }
                            catch (NumberFormatException nfe) {
                                LOG.warn("Could not parse update-field 'acktime' value '{}' as a Long. Using current time instead.", (Object)expandedAckTime);
                                alarm.setAlarmAckTime(Calendar.getInstance().getTime());
                            }
                            continue;
                        }
                        if (expandedAckTime.toLowerCase().matches("^0x[0-9a-f]{22}$") || expandedAckTime.toLowerCase().matches("^0x[0-9a-f]{16}$")) {
                            alarm.setAlarmAckTime(this.m_eventUtil.decodeSnmpV2TcDateAndTime(new BigInteger(expandedAckTime.substring(2), 16)));
                            continue;
                        }
                        LOG.warn("Not sure what to do with update-field 'acktime' value '{}'. Using current time instead.", (Object)expandedAckTime);
                        alarm.setAlarmAckTime(Calendar.getInstance().getTime());
                        continue;
                    }
                    if (!fieldName.toLowerCase().startsWith("ackuser")) continue;
                    String expandedAckUser = this.m_eventUtil.expandParms(field.getValueExpression(), event);
                    if ("null".equalsIgnoreCase(expandedAckUser) || "".equals(expandedAckUser)) {
                        alarm.unacknowledge("admin");
                        continue;
                    }
                    alarm.setAlarmAckUser(expandedAckUser);
                    continue;
                }
                LOG.warn("reduceEvent: The specified field: {}, is not supported, instanceId={}, alarmId={}", new Object[]{fieldName, SystemInfoUtils.getInstanceId(), alarm.getId()});
            }
        }
        this.updateRelatedAlarms(alarm, event);
        persistedEvent.setAlarm(alarm);
    }

    private void updateRelatedAlarms(OnmsAlarm alarm, Event event) {
        Set<OnmsAlarm> relatedAlarms = this.getRelatedAlarms(event.getParmCollection());
        Map<Integer, OnmsAlarm> relatedAlarmsByIds = relatedAlarms.stream().collect(Collectors.toMap(OnmsAlarm::getId, a -> a));
        ImmutableSet relatedAlarmIdsFromEvent = ImmutableSet.copyOf(relatedAlarmsByIds.keySet());
        ImmutableSet relatedAlarmIdsFromExistingAlarm = ImmutableSet.copyOf((Collection)alarm.getRelatedAlarmIds());
        Sets.difference((Set)relatedAlarmIdsFromExistingAlarm, (Set)relatedAlarmIdsFromEvent).forEach(arg_0 -> ((OnmsAlarm)alarm).removeRelatedAlarmWithId(arg_0));
        Sets.difference((Set)relatedAlarmIdsFromEvent, (Set)relatedAlarmIdsFromExistingAlarm).forEach(relatedAlarmIdToAdd -> {
            OnmsAlarm related = (OnmsAlarm)relatedAlarmsByIds.get(relatedAlarmIdToAdd);
            if (related != null) {
                if (!this.formingCyclicGraph(alarm, related)) {
                    alarm.addRelatedAlarm(related);
                } else {
                    LOG.warn("Alarm with id '{}' , reductionKey '{}' is not added as related alarm for id '{}' as it is forming cyclic graph ", new Object[]{related.getId(), related.getReductionKey(), alarm.getId()});
                }
            }
        });
    }

    private void resetAlarmSeverity(OnmsEvent persistedEvent, OnmsAlarm alarm) {
        alarm.setSeverity(OnmsSeverity.valueOf((String)persistedEvent.getSeverityLabel()));
    }

    private void incrementCounter(OnmsAlarm alarm) {
        alarm.setCounter(Integer.valueOf(alarm.getCounter() + 1));
    }

    private boolean isResolvedAlarm(OnmsAlarm alarm) {
        return alarm.getAlarmType() == 2;
    }

    private boolean isResolutionEvent(Event event) {
        return Objects.equals(event.getAlarmData().getAlarmType(), 2);
    }

    private OnmsAlarm createNewAlarm(OnmsEvent e, Event event) {
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setRelatedAlarms(this.getRelatedAlarms(event.getParmCollection()), event.getTime());
        alarm.setAlarmType(event.getAlarmData().getAlarmType());
        alarm.setClearKey(event.getAlarmData().getClearKey());
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDescription(e.getEventDescr());
        alarm.setDistPoller(e.getDistPoller());
        alarm.setFirstEventTime(e.getEventTime());
        alarm.setIfIndex(e.getIfIndex());
        alarm.setIpAddr(e.getIpAddr());
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLastEvent(e);
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setMouseOverText(e.getEventMouseOverText());
        alarm.setNode(e.getNode());
        alarm.setOperInstruct(e.getEventOperInstruct());
        alarm.setReductionKey(event.getAlarmData().getReductionKey());
        alarm.setServiceType(e.getServiceType());
        alarm.setSeverity(OnmsSeverity.get((int)e.getEventSeverity()));
        alarm.setSuppressedUntil(e.getEventTime());
        alarm.setSuppressedTime(e.getEventTime());
        alarm.setUei(e.getEventUei());
        if (event.getAlarmData().getManagedObject() != null) {
            alarm.setManagedObjectType(event.getAlarmData().getManagedObject().getType());
        }
        e.setAlarm(alarm);
        return alarm;
    }

    private boolean formingCyclicGraph(OnmsAlarm situation, OnmsAlarm relatedAlarm) {
        return situation.getReductionKey().equals(relatedAlarm.getReductionKey()) || relatedAlarm.getRelatedAlarms().stream().anyMatch(ra -> this.formingCyclicGraph(situation, (OnmsAlarm)ra));
    }

    private Set<OnmsAlarm> getRelatedAlarms(List<Parm> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        Set reductionKeys = list.stream().filter(AlarmPersisterImpl::isRelatedReductionKeyWithContent).map(p -> p.getValue().getContent()).collect(Collectors.toSet());
        return reductionKeys.stream().map(reductionKey -> this.m_alarmDao.findByReductionKey(reductionKey)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static boolean isRelatedReductionKeyWithContent(Parm param) {
        return param.getParmName() != null && param.getParmName().startsWith(RELATED_REDUCTION_KEY_PREFIX) && param.getValue() != null && param.getValue().getContent() != null;
    }

    private static boolean checkEventSanityAndDoWeProcess(Event event) {
        if (event.getLogmsg() != null && LogDestType.DONOTPERSIST.toString().equalsIgnoreCase(event.getLogmsg().getDest())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkEventSanity: uei '{}' marked as '{}'; not processing event, instanceId={}, eventId={}", new Object[]{event.getUei(), LogDestType.DONOTPERSIST, SystemInfoUtils.getInstanceId(), event.getDbid()});
            }
            return false;
        }
        if (event.getAlarmData() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkEventSanity: uei '{}' has no alarm data; not processing event, instanceId={}, eventId={}", new Object[]{event.getUei(), SystemInfoUtils.getInstanceId(), event.getDbid()});
            }
            return false;
        }
        if (event.getDbid() <= 0L) {
            throw new IllegalArgumentException("Incoming event has an illegal dbid (" + event.getDbid() + "), aborting");
        }
        return true;
    }

    private static Collection<String> getLockKeys(Event event) {
        if (event.getAlarmData().getClearKey() == null) {
            return Collections.singletonList(event.getAlarmData().getReductionKey());
        }
        return Arrays.asList(event.getAlarmData().getReductionKey(), event.getAlarmData().getClearKey());
    }

    public TransactionOperations getTransactionOperations() {
        return this.m_transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventUtil(EventUtil eventUtil) {
        this.m_eventUtil = eventUtil;
    }

    public EventUtil getEventUtil() {
        return this.m_eventUtil;
    }

    public AlarmEntityNotifier getAlarmChangeListener() {
        return this.m_alarmEntityNotifier;
    }

    public void setAlarmChangeListener(AlarmEntityNotifier alarmEntityNotifier) {
        this.m_alarmEntityNotifier = alarmEntityNotifier;
    }

    public void onExtensionRegistered(AlarmPersisterExtension ext, Map<String, String> properties) {
        LOG.debug("onExtensionRegistered: {} with properties: {}", (Object)ext, properties);
        this.extensions.add(ext);
    }

    public void onExtensionUnregistered(AlarmPersisterExtension ext, Map<String, String> properties) {
        LOG.debug("onExtensionUnregistered: {} with properties: {}", (Object)ext, properties);
        this.extensions.remove(ext);
    }

    public boolean isCreateNewAlarmIfClearedAlarmExists() {
        return this.m_createNewAlarmIfClearedAlarmExists;
    }

    public void setCreateNewAlarmIfClearedAlarmExists(boolean createNewAlarmIfClearedAlarmExists) {
        this.m_createNewAlarmIfClearedAlarmExists = createNewAlarmIfClearedAlarmExists;
    }

    public boolean islegacyAlarmState() {
        return this.m_legacyAlarmState;
    }

    public void setLegacyAlarmState(boolean legacyAlarmState) {
        this.m_legacyAlarmState = legacyAlarmState;
    }
}

