/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnmpValue
implements SnmpValue {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSnmpValue.class);
    public static final String ADDITIONAL_PRINTABLE_CHARACTERS_PROPERTY = "org.opennms.netmgt.snmp.additionalPrintableCharacters";
    private static Map<Byte, Byte> ADDITIONAL_PRINTABLE_CHARACTERS;

    public static boolean allBytesDisplayable(byte[] bytes) {
        if (AbstractSnmpValue.allBytesUTF_8(bytes)) {
            return true;
        }
        return AbstractSnmpValue.allBytesISO_8859_1(bytes);
    }

    public static boolean allBytesUTF_8(byte[] bytes) {
        int i = 0;
        if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
            i = 3;
        }
        int j = bytes.length;
        while (i < j) {
            if (!AbstractSnmpValue.getAdditionalPrintableCharacters().containsKey(bytes[i])) {
                byte octet = bytes[i];
                if ((octet & 0x80) == 0) {
                    if (octet == 0) {
                        if (i != j - 1) {
                            return false;
                        }
                    } else {
                        if (octet < 32 && octet != 9 && octet != 10 && octet != 13) {
                            return false;
                        }
                        if (octet == 127) {
                            return false;
                        }
                    }
                } else {
                    int end;
                    if ((octet & 0xE0) == 192) {
                        end = i + 1;
                    } else if ((octet & 0xF0) == 224) {
                        end = i + 2;
                    } else if ((octet & 0xF8) == 240) {
                        end = i + 3;
                    } else {
                        return false;
                    }
                    while (i < end) {
                        if (++i >= bytes.length) {
                            return false;
                        }
                        octet = bytes[i];
                        if ((octet & 0xC0) == 128) continue;
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean allBytesISO_8859_1(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (AbstractSnmpValue.getAdditionalPrintableCharacters().containsKey(b)) continue;
            if (b == 0) {
                if (i == bytes.length - 1) continue;
                return false;
            }
            if (b >= 0 && b < 32 && b != 9 && b != 10 && b != 13) {
                return false;
            }
            if (b == 127) {
                return false;
            }
            if (b < -128 || b >= -96) continue;
            return false;
        }
        return true;
    }

    public static Map<Byte, Byte> getAdditionalPrintableCharacters() {
        if (ADDITIONAL_PRINTABLE_CHARACTERS == null) {
            HashMap<Byte, Byte> mappedCharacters = new HashMap<Byte, Byte>();
            String[] mappings = System.getProperty(ADDITIONAL_PRINTABLE_CHARACTERS_PROPERTY, "").split(",");
            if (mappings.length == 0) {
                return mappedCharacters;
            }
            for (String mapping : mappings) {
                byte srcChar;
                String[] strings = mapping.split(":");
                if (strings.length == 1 && !"".equals(strings[0])) {
                    try {
                        srcChar = Byte.decode(strings[0]);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Cannot decode '{}' to byte", (Object)strings[0], (Object)e);
                        continue;
                    }
                    mappedCharacters.put(srcChar, srcChar);
                    continue;
                }
                if (strings.length == 2) {
                    byte dstChar;
                    try {
                        srcChar = Byte.decode(strings[0]);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Cannot decode '{}' to byte", (Object)strings[0], (Object)e);
                        continue;
                    }
                    try {
                        dstChar = Byte.decode(strings[1]);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Cannot decode '{}' to byte", (Object)strings[1], (Object)e);
                        continue;
                    }
                    mappedCharacters.put(srcChar, dstChar);
                    continue;
                }
                LOG.debug("Cannot parse mapping '{}'", (Object)mapping);
            }
            ADDITIONAL_PRINTABLE_CHARACTERS = mappedCharacters;
        }
        return ADDITIONAL_PRINTABLE_CHARACTERS;
    }

    public static void invalidateAdditionalCharacters() {
        ADDITIONAL_PRINTABLE_CHARACTERS = null;
    }
}

