/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqprivate;

import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.iqprivate.packet.DefaultPrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;

public class PrivateDataManager
extends Manager {
    private static final Map<XMPPConnection, PrivateDataManager> instances = new WeakHashMap<XMPPConnection, PrivateDataManager>();
    private static Map<String, PrivateDataProvider> privateDataProviders = new Hashtable<String, PrivateDataProvider>();

    public static synchronized PrivateDataManager getInstanceFor(XMPPConnection connection) {
        PrivateDataManager privateDataManager = instances.get(connection);
        if (privateDataManager == null) {
            privateDataManager = new PrivateDataManager(connection);
        }
        return privateDataManager;
    }

    public static PrivateDataProvider getPrivateDataProvider(String elementName, String namespace) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        return privateDataProviders.get(key);
    }

    public static void addPrivateDataProvider(String elementName, String namespace, PrivateDataProvider provider) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        privateDataProviders.put(key, provider);
    }

    public static void removePrivateDataProvider(String elementName, String namespace) {
        String key = PrivateDataManager.getProviderKey(elementName, namespace);
        privateDataProviders.remove(key);
    }

    private PrivateDataManager(XMPPConnection connection) {
        super(connection);
        instances.put(connection, this);
    }

    public PrivateData getPrivateData(final String elementName, final String namespace) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        IQ privateDataGet = new IQ(){

            public String getChildElementXML() {
                StringBuilder buf = new StringBuilder();
                buf.append("<query xmlns=\"jabber:iq:private\">");
                buf.append("<").append(elementName).append(" xmlns=\"").append(namespace).append("\"/>");
                buf.append("</query>");
                return buf.toString();
            }
        };
        privateDataGet.setType(IQ.Type.GET);
        PrivateDataResult response = (PrivateDataResult)this.connection().createPacketCollectorAndSend(privateDataGet).nextResultOrThrow();
        return response.getPrivateData();
    }

    public void setPrivateData(final PrivateData privateData) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        IQ privateDataSet = new IQ(){

            public String getChildElementXML() {
                StringBuilder buf = new StringBuilder();
                buf.append("<query xmlns=\"jabber:iq:private\">");
                buf.append(privateData.toXML());
                buf.append("</query>");
                return buf.toString();
            }
        };
        privateDataSet.setType(IQ.Type.SET);
        this.connection().createPacketCollectorAndSend(privateDataSet).nextResultOrThrow();
    }

    private static String getProviderKey(String elementName, String namespace) {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(elementName).append("/><").append(namespace).append("/>");
        return buf.toString();
    }

    private static class PrivateDataResult
    extends IQ {
        private PrivateData privateData;

        PrivateDataResult(PrivateData privateData) {
            this.privateData = privateData;
        }

        public PrivateData getPrivateData() {
            return this.privateData;
        }

        public String getChildElementXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<query xmlns=\"jabber:iq:private\">");
            if (this.privateData != null) {
                buf.append(this.privateData.toXML());
            }
            buf.append("</query>");
            return buf.toString();
        }
    }

    public static class PrivateDataIQProvider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            PrivateData privateData = null;
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    String namespace;
                    String elementName = parser.getName();
                    PrivateDataProvider provider = PrivateDataManager.getPrivateDataProvider(elementName, namespace = parser.getNamespace());
                    if (provider != null) {
                        privateData = provider.parsePrivateData(parser);
                        continue;
                    }
                    DefaultPrivateData data = new DefaultPrivateData(elementName, namespace);
                    boolean finished = false;
                    while (!finished) {
                        int event = parser.next();
                        if (event == 2) {
                            String name = parser.getName();
                            if (parser.isEmptyElementTag()) {
                                data.setValue(name, "");
                                continue;
                            }
                            event = parser.next();
                            if (event != 4) continue;
                            String value = parser.getText();
                            data.setValue(name, value);
                            continue;
                        }
                        if (event != 3 || !parser.getName().equals(elementName)) continue;
                        finished = true;
                    }
                    privateData = data;
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("query")) continue;
                done = true;
            }
            return new PrivateDataResult(privateData);
        }
    }
}

